/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.uncommons.watchmaker.framework.interactive.Console;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingConsole
extends JPanel
implements Console<JComponent> {
    private final Lock lock = new ReentrantLock();
    private final Condition selected = this.lock.newCondition();
    private final AtomicInteger selectedIndex = new AtomicInteger(-1);

    public SwingConsole() {
        this(3);
    }

    public SwingConsole(int columns) {
        super(new GridLayout(0, columns));
    }

    public int select(final List<? extends JComponent> renderedEntities) {
        this.selectedIndex.set(-1);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SwingConsole.this.removeAll();
                int index = -1;
                for (JComponent entity : renderedEntities) {
                    SwingConsole.this.add(new EntityPanel(entity, ++index));
                }
                SwingConsole.this.revalidate();
            }
        });
        this.waitForSelection();
        return this.selectedIndex.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForSelection() {
        this.lock.lock();
        try {
            while (this.selectedIndex.get() < 0) {
                this.selected.awaitUninterruptibly();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private class EntityPanel
    extends JPanel {
        EntityPanel(JComponent entityComponent, final int index) {
            super(new BorderLayout());
            this.add((Component)entityComponent, "Center");
            JButton selectButton = new JButton("Select");
            selectButton.setName("Selection-" + index);
            selectButton.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent actionEvent) {
                    SwingConsole.this.lock.lock();
                    try {
                        SwingConsole.this.selectedIndex.set(index);
                        SwingConsole.this.selected.signalAll();
                    }
                    finally {
                        SwingConsole.this.lock.unlock();
                    }
                }
            });
            this.add((Component)selectButton, "South");
            this.setBorder(BorderFactory.createEtchedBorder());
        }
    }
}

