/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.converter.basic;

import java.lang.reflect.Type;
import org.unidal.converter.Converter;
import org.unidal.converter.ConverterException;
import org.unidal.converter.TypeUtil;

public class EnumConverter<T extends Enum<T>>
implements Converter<T> {
    @Override
    public boolean canConvert(Type fromType, Type targetType) {
        Class<?> fromClass = TypeUtil.getRawType(fromType);
        return String.class.isAssignableFrom(fromClass);
    }

    @Override
    public T convert(Object from, Type targetType) throws ConverterException {
        String name = (String)from;
        Class<?> targetClass = TypeUtil.getRawType(targetType);
        return (T)Enum.valueOf(targetClass, name);
    }

    @Override
    public Type getTargetType() {
        return Enum.class;
    }
}

