/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.converter.basic;

import java.lang.reflect.Type;
import org.unidal.converter.Converter;
import org.unidal.converter.ConverterException;
import org.unidal.converter.TypeUtil;

public class IntegerConverter
implements Converter<Integer> {
    @Override
    public boolean canConvert(Type fromType, Type targetType) {
        return TypeUtil.isTypeSupported(fromType, new Type[]{Number.class, Boolean.TYPE, Boolean.class, String.class, Enum.class});
    }

    @Override
    public Integer convert(Object from, Type targetType) throws ConverterException {
        if (from instanceof Number) {
            return ((Number)from).intValue();
        }
        if (from instanceof Boolean) {
            return (Boolean)from != false ? Integer.valueOf(1) : 0;
        }
        if (from instanceof Enum) {
            return ((Enum)from).ordinal();
        }
        try {
            return Integer.valueOf(from.toString().trim());
        }
        catch (NumberFormatException e) {
            throw new ConverterException(e);
        }
    }

    @Override
    public Type getTargetType() {
        return Integer.class;
    }
}

