/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.converter.dom;

import java.lang.reflect.Type;
import org.unidal.converter.Converter;
import org.unidal.converter.ConverterException;
import org.unidal.converter.TypeUtil;
import org.w3c.dom.Node;

public class NodeValueConverter
implements Converter<String> {
    @Override
    public boolean canConvert(Type fromType, Type targetType) {
        Class<?> fromClass = TypeUtil.getRawType(fromType);
        return Node.class.isAssignableFrom(fromClass);
    }

    @Override
    public String convert(Object from, Type targetType) throws ConverterException {
        Node node = (Node)from;
        switch (node.getNodeType()) {
            case 2: {
                return node.getNodeValue();
            }
            case 1: {
                Node firstChild = node.getFirstChild();
                switch (firstChild.getNodeType()) {
                    case 3: 
                    case 4: {
                        return firstChild.getNodeValue();
                    }
                }
            }
        }
        throw new ConverterException("Can't convert from " + from + " to " + targetType);
    }

    @Override
    public Type getTargetType() {
        return String.class;
    }
}

