/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.helper;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.unidal.helper.Dates;

public enum Inets {
    IP4{

        @Override
        protected List<Address> getAllInetAddresses() {
            ArrayList<Address> all;
            block4: {
                all = new ArrayList<Address>();
                try {
                    ArrayList<NetworkInterface> nis = Collections.list(NetworkInterface.getNetworkInterfaces());
                    for (NetworkInterface ni : nis) {
                        this.print(ni);
                        if (!ni.isUp()) continue;
                        ArrayList<InetAddress> addresses = Collections.list(ni.getInetAddresses());
                        for (InetAddress address : addresses) {
                            if (!(address instanceof Inet4Address)) continue;
                            all.add(new Address(address, ni));
                        }
                    }
                }
                catch (SocketException e) {
                    if (!this.isVerbose()) break block4;
                    e.printStackTrace();
                }
            }
            return all;
        }
    };

    private InetAddress m_localHost;
    private String m_localHostAddress;
    private String m_localHostName;
    private AtomicBoolean m_initialized = new AtomicBoolean();

    public static void main(String[] args) {
        System.setProperty("verbose", "true");
        IP4.getLocalHostAddress();
    }

    InetAddress filterAddresses(List<Address> addresses) {
        InetAddress local = null;
        int size = addresses.size();
        int maxWeight = -1;
        for (int i = 0; i < size; ++i) {
            Address address = addresses.get(i);
            int weight = 0;
            if (address.isSiteLocalAddress()) {
                weight += 8;
            }
            if (address.isLinkLocalAddress()) {
                weight += 4;
            }
            if (address.isLoopbackAddress()) {
                weight += 2;
            }
            if (address.hasHostName()) {
                ++weight;
            }
            if (weight <= maxWeight) continue;
            maxWeight = weight;
            local = address.getAddress();
        }
        return local;
    }

    protected abstract List<Address> getAllInetAddresses();

    public String getLocalHostAddress() {
        this.initialize();
        return this.m_localHostAddress;
    }

    public String getLocalHostName() {
        this.initialize();
        return this.m_localHostName;
    }

    private InetAddress getLocalInetAddress() {
        String ip = System.getProperty("host.ip");
        if (ip == null) {
            ip = System.getenv("HOST_IP");
        }
        if (ip != null) {
            try {
                return InetAddress.getByName(ip);
            }
            catch (Exception e) {
                this.print("Unable to resolve ip: " + ip + "! " + e);
            }
        }
        List<Address> addresses = this.getAllInetAddresses();
        InetAddress address = this.filterAddresses(addresses);
        return address;
    }

    private synchronized void initialize() {
        if (!this.m_initialized.get()) {
            this.m_localHost = this.getLocalInetAddress();
            if (this.m_localHost == null) {
                try {
                    this.m_localHost = Inet4Address.getLocalHost();
                }
                catch (UnknownHostException e) {
                    String message = "No network configured!";
                    this.print(message);
                    throw new IllegalStateException(message);
                }
            }
            this.m_localHostAddress = this.m_localHost.getHostAddress();
            this.m_localHostName = this.m_localHost.getHostName();
            this.m_initialized.set(true);
            this.print(Dates.now().asString("[yyyy-MM-dd HH:mm:ss] ") + " ip address: " + this.m_localHostAddress);
        }
    }

    protected boolean isVerbose() {
        String verbose = System.getProperty("verbose");
        return "true".equals(verbose);
    }

    protected void print(NetworkInterface ni) throws SocketException {
        if (this.isVerbose()) {
            StringBuilder sb = new StringBuilder();
            sb.append(ni.getName()).append(": ");
            sb.append("flags=<");
            if (ni.isUp()) {
                sb.append("UP,");
            }
            if (ni.isLoopback()) {
                sb.append("LOOPBACK,");
            }
            if (ni.isPointToPoint()) {
                sb.append("POINTOPOINT,");
            }
            if (ni.isVirtual()) {
                sb.append("VIRTUAL,");
            }
            if (ni.supportsMulticast()) {
                sb.append("MULTICAST,");
            }
            if (sb.charAt(sb.length() - 1) == '<') {
                sb.append('>');
            } else {
                sb.setCharAt(sb.length() - 1, '>');
            }
            sb.append(" mtu ").append(ni.getMTU());
            sb.append("\r\n");
            for (InetAddress address : Collections.list(ni.getInetAddresses())) {
                if (!(address instanceof Inet4Address)) continue;
                sb.append("    ").append(address.getHostAddress());
                sb.append(" flags=<");
                if (address.isSiteLocalAddress()) {
                    sb.append("sitelocal,");
                }
                if (address.isLinkLocalAddress()) {
                    sb.append("linklocal,");
                }
                if (address.isLoopbackAddress()) {
                    sb.append("loopback,");
                }
                if (sb.charAt(sb.length() - 1) == '<') {
                    sb.append('>');
                } else {
                    sb.setCharAt(sb.length() - 1, '>');
                }
                sb.append("\r\n");
            }
            System.out.println(sb.toString());
        }
    }

    protected void print(String message) {
        if (this.isVerbose()) {
            System.out.println(Dates.now().asString("[yyyy-MM-dd HH:mm:ss] ") + message);
        }
    }

    static class Address {
        private InetAddress m_address;
        private boolean m_loopback;

        public Address(InetAddress address, NetworkInterface ni) {
            this.m_address = address;
            try {
                if (ni != null && ni.isLoopback()) {
                    this.m_loopback = true;
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }

        public InetAddress getAddress() {
            return this.m_address;
        }

        public boolean hasHostName() {
            return !this.m_address.getHostName().equals(this.m_address.getHostAddress());
        }

        public boolean isLinkLocalAddress() {
            return !this.m_loopback && this.m_address.isLinkLocalAddress();
        }

        public boolean isLoopbackAddress() {
            return this.m_loopback || this.m_address.isLoopbackAddress();
        }

        public boolean isSiteLocalAddress() {
            return !this.m_loopback && this.m_address.isSiteLocalAddress();
        }
    }
}

