/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.lookup;

import com.google.common.collect.Multimap;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.manager.ComponentManagerFactory;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.lifecycle.LifecycleHandler;
import org.codehaus.plexus.lifecycle.UndefinedLifecycleHandlerException;
import org.codehaus.plexus.lifecycle.phase.Phase;
import org.junit.After;
import org.junit.Before;
import org.unidal.helper.Reflects;
import org.unidal.lookup.ContainerHolder;
import org.unidal.lookup.ContainerLoader;
import org.unidal.lookup.configuration.Configuration;
import org.unidal.lookup.extension.EnumComponentManagerFactory;
import org.unidal.lookup.extension.PostConstructionPhase;

public abstract class ComponentTestCase
extends ContainerHolder {
    protected static final String PER_LOOKUP = "per-lookup";
    private MutablePlexusContainer m_container;
    private Map<Object, Object> m_context;
    private String m_basedir;

    protected void browse(String url) throws IOException {
        Desktop.getDesktop().browse(URI.create(url));
    }

    protected <T> ComponentDefinition<T> defineComponent(Class<T> role) throws Exception {
        return this.defineComponent(role, null, role);
    }

    protected <T> ComponentDefinition<T> defineComponent(Class<T> role, Class<? extends T> implementation) throws Exception {
        return this.defineComponent(role, null, implementation);
    }

    protected <T> ComponentDefinition<T> defineComponent(Class<T> role, String roleHint, Class<? extends T> implementation) throws Exception {
        if (roleHint == null) {
            roleHint = "default";
        }
        ComponentDescriptor descriptor = new ComponentDescriptor(implementation, this.m_container.getContainerRealm());
        descriptor.setRoleClass(role);
        descriptor.setRoleHint(roleHint);
        Map index = (Map)Reflects.forField().getDeclaredFieldValue(this.m_container, "componentRegistry", "repository", "index");
        for (SortedMap roleIndex : index.values()) {
            Multimap roleHintIndex = (Multimap)roleIndex.get(role.getName());
            if (roleHintIndex == null) continue;
            roleHintIndex.removeAll((Object)roleHint);
        }
        this.m_container.addComponentDescriptor(descriptor);
        return new ComponentDefinition(descriptor);
    }

    protected String getBaseDir() {
        if (this.m_basedir != null) {
            return this.m_basedir;
        }
        this.m_basedir = System.getProperty("basedir");
        if (this.m_basedir == null) {
            try {
                this.m_basedir = new File(".").getCanonicalPath();
            }
            catch (IOException e) {
                this.m_basedir = "";
            }
        }
        return this.m_basedir;
    }

    protected DefaultContainerConfiguration getConfiguration() throws Exception, UndefinedLifecycleHandlerException {
        String customConfigurationName = this.getCustomConfigurationName();
        DefaultContainerConfiguration configuration = new DefaultContainerConfiguration();
        configuration.setName("test").setContext(this.m_context);
        if (customConfigurationName != null) {
            configuration.setContainerConfiguration(customConfigurationName);
        } else {
            String defaultConfigurationName = this.getDefaultConfigurationName();
            configuration.setContainerConfiguration(defaultConfigurationName);
        }
        LifecycleHandler plexus = configuration.getLifecycleHandlerManager().getLifecycleHandler("plexus");
        plexus.addBeginSegment((Phase)new PostConstructionPhase());
        return configuration;
    }

    public MutablePlexusContainer getContainer() {
        return (MutablePlexusContainer)super.getContainer();
    }

    protected String getCustomConfigurationName() {
        return null;
    }

    protected String getDefaultConfigurationName() throws Exception {
        return this.getClass().getName().replace('.', '/') + ".xml";
    }

    @Before
    public void setUp() throws Exception {
        this.m_basedir = this.getBaseDir();
        this.m_context = new HashMap<Object, Object>();
        this.m_context.put("basedir", this.m_basedir);
        boolean hasPlexusHome = this.m_context.containsKey("plexus.home");
        if (!hasPlexusHome) {
            File f = new File(this.m_basedir, "target/plexus-home");
            if (!f.isDirectory()) {
                f.mkdir();
            }
            this.m_context.put("plexus.home", f.getAbsolutePath());
        }
        this.m_container = (MutablePlexusContainer)ContainerLoader.getDefaultContainer((ContainerConfiguration)this.getConfiguration());
        this.m_container.getComponentRegistry().registerComponentManagerFactory((ComponentManagerFactory)new EnumComponentManagerFactory());
        System.setProperty("devMode", "true");
        super.setContainer((PlexusContainer)this.m_container);
    }

    @After
    public void tearDown() throws Exception {
        ContainerLoader.destroyDefaultContainer();
    }

    public static final class ComponentDefinition<T> {
        private ComponentDescriptor<T> m_descriptor;
        private Configuration m_config;

        public ComponentDefinition(ComponentDescriptor<T> descriptor) {
            this.m_descriptor = descriptor;
        }

        public ComponentDefinition<T> config(String name, String value) {
            if (this.m_config == null) {
                this.m_config = new Configuration();
                this.m_descriptor.setConfiguration((PlexusConfiguration)this.m_config);
            }
            this.m_config.addChild(name, value);
            return this;
        }

        public ComponentDefinition<T> is(String instantiationStrategy) {
            this.m_descriptor.setInstantiationStrategy(instantiationStrategy);
            return this;
        }

        public ComponentDefinition<T> req(Class<?> role) {
            return this.req(role, null);
        }

        public ComponentDefinition<T> req(Class<?> role, String roleHint) {
            ComponentRequirement requirement = new ComponentRequirement();
            requirement.setRole(role.getName());
            if (roleHint != null) {
                requirement.setRoleHint(roleHint);
            } else {
                requirement.setRoleHint("default");
            }
            this.m_descriptor.addRequirement(requirement);
            return this;
        }
    }
}

