/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.lookup.configuration;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.codehaus.plexus.component.repository.io.PlexusTools;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;

public abstract class AbstractScriptConfiguration
implements Initializable {
    private String m_projectName;
    private String m_config;
    private Properties m_properties;
    private PlexusConfiguration m_configuration;

    protected AbstractScriptConfiguration(String projectName) {
        this.m_projectName = projectName;
    }

    protected static void generateScriptFile(AbstractScriptConfiguration configuration, File script, boolean isUnix) {
        try {
            configuration.setConfig("config.xml");
            configuration.initialize();
            String content = configuration.generateScript(isUnix);
            script.getParentFile().mkdirs();
            FileUtils.fileWrite((String)script.getPath(), (String)content);
            System.out.println("File " + script.getCanonicalPath() + " generated. File length is " + script.length());
        }
        catch (Exception e) {
            System.err.println("Error when generating " + script + " file.");
            e.printStackTrace();
        }
    }

    private String generateScript(boolean isUnix) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException {
        String lf;
        Map<Property, Method> map = this.getPropertyMap();
        StringBuilder sb = new StringBuilder(2048);
        StringBuilder options = new StringBuilder(256);
        String prefix = isUnix ? "# " : "REM ";
        String string = lf = isUnix ? "\n" : "\r\n";
        if (!isUnix) {
            sb.append("@echo off").append(lf);
        }
        sb.append(prefix).append("JDK version 1.5 is required. However, it does not work on JDK 1.6.").append(lf);
        sb.append(prefix).append("Following system properties are supported by this robot:").append(lf);
        for (Map.Entry<Property, Method> e : map.entrySet()) {
            String name = e.getKey().name();
            String desc = e.getKey().desc();
            Object value = e.getValue().invoke((Object)this, new Object[0]);
            sb.append(prefix).append("   -D").append(this.pad(name, 20)).append(desc);
            sb.append(" Default value is \"").append(value).append("\".");
            sb.append(lf);
            if (!e.getKey().required()) continue;
            options.append(" -D").append(name).append('=').append(value);
        }
        sb.append(lf);
        sb.append("java").append((CharSequence)options).append(" -jar ").append(this.m_projectName).append(".jar").append(lf);
        return sb.toString();
    }

    protected String getParameterValue(String property) {
        PlexusConfiguration parameters;
        PlexusConfiguration parameter;
        PlexusConfiguration defaultValue;
        String value = this.m_properties.getProperty(property);
        if (value == null && (value = (defaultValue = (parameter = (parameters = this.m_configuration.getChild("parameters")).getChild(property)).getChild("default-value")).getValue(null)) == null) {
            throw new IllegalArgumentException("Parameter(" + property + ") should be defined at " + this.m_config + " or be passed in from command line");
        }
        return value;
    }

    protected int getParameterValue(String property, int defaultValue) {
        try {
            return Integer.parseInt(this.getParameterValue(property));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    protected boolean getParameterValue(String property, boolean defaultValue) {
        try {
            return Boolean.getBoolean(this.getParameterValue(property));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    protected String getParameterValue(String property, String defaultValue) {
        try {
            return this.getParameterValue(property);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private Map<Property, Method> getPropertyMap() {
        LinkedHashMap<Property, Method> map = new LinkedHashMap<Property, Method>();
        ArrayList<Method> allMethods = new ArrayList<Method>();
        for (Class<?> clazz = this.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                allMethods.add(method);
            }
        }
        for (Method method : allMethods) {
            Property property = method.getAnnotation(Property.class);
            if (property == null) continue;
            method.setAccessible(true);
            map.put(property, method);
        }
        return map;
    }

    public void initialize() throws InitializationException {
        try {
            XmlStreamReader reader;
            String config = System.getProperty("config");
            if (config != null) {
                this.m_config = config;
            }
            if (new File(this.m_config).canRead()) {
                reader = ReaderFactory.newXmlReader((File)new File(this.m_config));
            } else {
                InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.m_config);
                if (is != null) {
                    reader = ReaderFactory.newXmlReader((InputStream)is);
                } else {
                    throw new InitializationException(this.m_config + " can't be found at current directory or as resource");
                }
            }
            this.m_configuration = PlexusTools.buildConfiguration((String)this.m_config, (Reader)reader);
            reader.close();
        }
        catch (Exception e) {
            throw new InitializationException("Error when loading XML configuration " + this.m_config, (Throwable)e);
        }
        this.m_properties = System.getProperties();
    }

    private String pad(String str, int maxLen) {
        StringBuilder sb = new StringBuilder(maxLen);
        sb.append(str);
        for (int i = str.length(); i < maxLen; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public void setConfig(String config) {
        this.m_config = System.getProperty("config", config);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Property {
        public String desc();

        public String name();

        public boolean required() default false;
    }
}

