/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.lookup.configuration;

import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.component.repository.ComponentRequirementList;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.unidal.lookup.configuration.Component;
import org.unidal.lookup.configuration.XmlPlexusConfigurationWriter;

public class Configurators {
    private Configurators() {
    }

    public static final Configurators forPlexus() {
        return new Configurators();
    }

    private XmlPlexusConfiguration generateComponent(Component c) {
        XmlPlexusConfiguration component = new XmlPlexusConfiguration("component");
        ComponentDescriptor<Object> d = c.getDescriptor();
        XmlPlexusConfiguration role = new XmlPlexusConfiguration("role");
        role.setValue(d.getRole());
        component.addChild((PlexusConfiguration)role);
        if (d.getRoleHint() != null && !d.getRoleHint().equals("default")) {
            XmlPlexusConfiguration roleHint = new XmlPlexusConfiguration("role-hint");
            roleHint.setValue(d.getRoleHint());
            component.addChild((PlexusConfiguration)roleHint);
        }
        XmlPlexusConfiguration implementation = new XmlPlexusConfiguration("implementation");
        implementation.setValue(d.getImplementation());
        component.addChild((PlexusConfiguration)implementation);
        if (d.getInstantiationStrategy() != null) {
            XmlPlexusConfiguration instantiationStrategy = new XmlPlexusConfiguration("instantiation-strategy");
            instantiationStrategy.setValue(d.getInstantiationStrategy());
            component.addChild((PlexusConfiguration)instantiationStrategy);
        }
        if (d.getLifecycleHandler() != null) {
            XmlPlexusConfiguration lifecycleHandler = new XmlPlexusConfiguration("lifecycle-handler");
            lifecycleHandler.setValue(d.getLifecycleHandler());
            component.addChild((PlexusConfiguration)lifecycleHandler);
        }
        if (c.getConfiguration() != null) {
            component.addChild((PlexusConfiguration)c.getConfiguration());
        }
        if (!c.getRequirements().isEmpty()) {
            XmlPlexusConfiguration requirements = new XmlPlexusConfiguration("requirements");
            for (ComponentRequirement r : c.getRequirements()) {
                requirements.addChild((PlexusConfiguration)this.generateComponentRequirement(r));
            }
            component.addChild((PlexusConfiguration)requirements);
        }
        return component;
    }

    private XmlPlexusConfiguration generateComponentRequirement(ComponentRequirement r) {
        XmlPlexusConfiguration requirement = new XmlPlexusConfiguration("requirement");
        XmlPlexusConfiguration role = new XmlPlexusConfiguration("role");
        role.setValue(r.getRole());
        requirement.addChild((PlexusConfiguration)role);
        if (r.getRoleHint() != null && !r.getRoleHint().equals("default")) {
            if (r instanceof ComponentRequirementList) {
                ComponentRequirementList list = (ComponentRequirementList)r;
                XmlPlexusConfiguration roleHints = new XmlPlexusConfiguration("role-hints");
                for (String hint : list.getRoleHints()) {
                    XmlPlexusConfiguration roleHint = new XmlPlexusConfiguration("role-hint");
                    roleHint.setValue(hint);
                    roleHints.addChild((PlexusConfiguration)roleHint);
                }
                requirement.addChild((PlexusConfiguration)roleHints);
            } else {
                XmlPlexusConfiguration roleHint = new XmlPlexusConfiguration("role-hint");
                roleHint.setValue(r.getRoleHint());
                requirement.addChild((PlexusConfiguration)roleHint);
            }
        }
        if (r.getFieldName() != null) {
            XmlPlexusConfiguration fieldName = new XmlPlexusConfiguration("field-name");
            fieldName.setValue(r.getFieldName());
            requirement.addChild((PlexusConfiguration)fieldName);
        }
        return requirement;
    }

    public String generateXmlConfiguration(List<Component> all) {
        XmlPlexusConfiguration plexus = new XmlPlexusConfiguration("plexus");
        XmlPlexusConfiguration components = new XmlPlexusConfiguration("components");
        for (Component item : all) {
            components.addChild((PlexusConfiguration)this.generateComponent(item));
        }
        plexus.addChild((PlexusConfiguration)components);
        return this.toString(plexus);
    }

    public String toString(XmlPlexusConfiguration plexus) {
        StringWriter sw = new StringWriter();
        XmlPlexusConfigurationWriter xw = new XmlPlexusConfigurationWriter();
        try {
            xw.write(sw, (PlexusConfiguration)plexus);
        }
        catch (IOException e) {
            // empty catch block
        }
        return sw.toString();
    }
}

