/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.concurrent;

import java.util.concurrent.atomic.AtomicReference;
import org.unidal.concurrent.Actor;
import org.unidal.concurrent.ActorContext;
import org.unidal.concurrent.ActorState;

public abstract class AbstractActor<E, C extends ActorContext<E>>
implements Actor<E, C> {
    private C m_ctx;
    private AtomicReference<ActorState> m_state = new AtomicReference<ActorState>(ActorState.WAITING);

    public AbstractActor(C ctx) {
        this.m_ctx = ctx;
    }

    @Override
    public ActorState checkState() {
        ActorState state = this.m_state.get();
        if (state.isWaiting() && this.m_ctx.isBatchReady()) {
            state = ActorState.RUNNABLE;
            this.m_state.set(state);
        }
        return state;
    }

    @Override
    public C getContext() {
        return this.m_ctx;
    }

    @Override
    public void play() throws InterruptedException {
        this.m_state.set(ActorState.RUNNING);
        this.run(this.m_ctx);
        if (this.m_ctx.isBatchReady()) {
            this.m_state.set(ActorState.RUNNABLE);
        } else {
            this.m_state.set(ActorState.WAITING);
        }
    }

    protected abstract void run(C var1) throws InterruptedException;
}

