/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.concurrent.internals;

import java.lang.reflect.Array;
import org.unidal.concurrent.StageStatus;

public class DefaultStageStatus
implements StageStatus {
    private int m_intervalInMillis;
    private int[] m_available;
    private long[] m_counts;
    private int[] m_costs;

    public DefaultStageStatus(int intervalInMillis) {
        this.m_intervalInMillis = intervalInMillis;
    }

    /*
     * WARNING - void declaration
     */
    public int checkThroughput(StageStatus last) {
        void var5_10;
        long totalCount = 0L;
        int totalCost = 0;
        for (long count : this.m_counts) {
            totalCount += count;
        }
        for (int cost : this.m_costs) {
            totalCost += cost;
        }
        boolean bl = false;
        if (totalCount == 0L) {
            int n = -1;
        } else if (totalCost > 0) {
            int threads = this.getThreads();
            if (totalCost > threads * 700) {
                boolean bl2 = true;
            } else if (totalCost < (threads - 1) * 700) {
                int n = -1;
            }
        }
        return (int)var5_10;
    }

    /*
     * WARNING - void declaration
     */
    int checkCapacity2() {
        void var5_11;
        int totalAvailable = 0;
        long totalCount = 0L;
        int totalCost = 0;
        for (int available : this.m_available) {
            totalAvailable += available;
        }
        for (long count : this.m_counts) {
            totalCount += count;
        }
        for (int cost : this.m_costs) {
            totalCost += cost;
        }
        boolean bl = false;
        if (totalCount == 0L) {
            int n = -1;
        } else if (totalCost > 0) {
            int threads = this.getThreads();
            long capacity = totalCount * (long)threads * (long)this.m_intervalInMillis / (long)totalCost;
            if ((long)(totalAvailable * 10) >= capacity) {
                boolean bl2 = true;
            } else if (capacity * (long)(threads - 1) < totalCount) {
                int n = -1;
            }
        }
        return (int)var5_11;
    }

    @Override
    public int getActors() {
        return this.m_available.length;
    }

    @Override
    public int[] getAvailable() {
        return this.m_available;
    }

    @Override
    public int getIntervalInMillis() {
        return this.m_intervalInMillis;
    }

    @Override
    public int[] getProcessedCosts() {
        return this.m_costs;
    }

    @Override
    public long[] getProcessedCounts() {
        return this.m_counts;
    }

    @Override
    public int getThreads() {
        return this.m_counts.length;
    }

    public void setAvailableCounts(int[] available) {
        this.m_available = available;
    }

    public void setProcessed(int[] costs, long[] counts) {
        this.m_costs = costs;
        this.m_counts = counts;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append(this.getClass().getSimpleName()).append('[');
        sb.append("interval=").append(this.m_intervalInMillis).append(", ");
        sb.append("actors=").append(this.getActors()).append(", ");
        sb.append("available=").append(this.toString(this.m_available)).append(", ");
        sb.append("threads=").append(this.getThreads()).append(", ");
        sb.append("processed=").append(this.toString(this.m_counts)).append(", ");
        sb.append("costs=").append(this.toString(this.m_costs)).append(", ");
        sb.setLength(sb.length() - 2);
        sb.append(']');
        return sb.toString();
    }

    private String toString(Object array) {
        int len = Array.getLength(array);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(',');
            } else {
                sb.append('[');
            }
            sb.append(Array.get(array, i));
            if (i != len - 1) continue;
            sb.append(']');
        }
        return sb.toString();
    }
}

