/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.concurrent.internals;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.unidal.concurrent.Stage;
import org.unidal.concurrent.internals.ThreadWorker;

public class DefaultThreadWorker
implements ThreadWorker {
    private Stage<?> m_stage;
    private int m_index;
    private AtomicLong m_count = new AtomicLong();
    private AtomicLong m_costInNanos = new AtomicLong();
    private AtomicBoolean m_enabled = new AtomicBoolean(true);
    private CountDownLatch m_latch = new CountDownLatch(1);

    public DefaultThreadWorker(Stage<?> stage, int index) {
        this.m_stage = stage;
        this.m_index = index;
    }

    @Override
    public int getAndResetCostInMillis() {
        return (int)(this.m_costInNanos.getAndSet(0L) / 1000000L);
    }

    @Override
    public long getAndResetCount() {
        return this.m_count.getAndSet(0L);
    }

    @Override
    public String getName() {
        return String.format("ThreadWorker[%s]-%s", this.m_stage.getId(), this.m_index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (this.m_enabled.get()) {
                long start = System.nanoTime();
                int count = this.m_stage.show();
                if (count > 0) {
                    this.m_costInNanos.addAndGet(System.nanoTime() - start);
                    this.m_count.addAndGet(count);
                    continue;
                }
                TimeUnit.MILLISECONDS.sleep(1L);
            }
        }
        catch (InterruptedException start) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            this.m_latch.countDown();
        }
    }

    @Override
    public void shutdown() {
        this.m_enabled.set(false);
        try {
            this.m_latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

