/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.converter.basic;

import java.lang.reflect.Type;
import org.unidal.converter.Converter;
import org.unidal.converter.ConverterException;
import org.unidal.converter.TypeUtil;

public class ByteConverter
implements Converter<Byte> {
    @Override
    public boolean canConvert(Type fromType, Type targetType) {
        return TypeUtil.isTypeSupported(fromType, new Type[]{Number.class, Boolean.TYPE, Boolean.class, String.class, Enum.class});
    }

    @Override
    public Byte convert(Object from, Type targetType) throws ConverterException {
        if (from instanceof Number) {
            return ((Number)from).byteValue();
        }
        if (from instanceof Boolean) {
            return (Boolean)from != false ? (byte)1 : 0;
        }
        if (from instanceof Enum) {
            return (byte)((Enum)from).ordinal();
        }
        try {
            return Byte.valueOf(from.toString());
        }
        catch (NumberFormatException e) {
            throw new ConverterException(e);
        }
    }

    @Override
    public Type getTargetType() {
        return Byte.class;
    }
}

