/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.helper;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Files {
    public static Dir forDir() {
        return Dir.INSTANCE;
    }

    public static IO forIO() {
        return IO.INSTANCE;
    }

    public static Zip forZip() {
        return Zip.INSTANCE;
    }

    public static enum Zip {
        INSTANCE;


        public List<String> copyDir(ZipInputStream zis, File baseDir) throws IOException {
            return this.copyDir(zis, baseDir, null);
        }

        public List<String> copyDir(ZipInputStream zis, File baseDir, Policy policy) throws IOException {
            ZipEntry entry;
            ArrayList<String> entryNames = new ArrayList<String>();
            if (!baseDir.exists()) {
                Dir.INSTANCE.createDir(baseDir);
            }
            while ((entry = zis.getNextEntry()) != null) {
                if (policy != null && !policy.apply(entry.getName())) continue;
                if (entry.isDirectory()) {
                    Dir.INSTANCE.createDir(new File(baseDir, entry.getName()));
                    continue;
                }
                File target = new File(baseDir, entry.getName());
                target.getParentFile().mkdirs();
                IO.INSTANCE.copy(zis, new FileOutputStream(target), AutoClose.OUTPUT);
            }
            return entryNames;
        }
    }

    public static interface Policy {
        public boolean apply(String var1);
    }

    public static enum IO {
        INSTANCE;


        public void copy(InputStream is, OutputStream os) throws IOException {
            this.copy(is, os, AutoClose.NONE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void copy(InputStream is, OutputStream os, AutoClose stream) throws IOException {
            byte[] content = new byte[4096];
            try {
                int size;
                while ((size = is.read(content)) != -1) {
                    os.write(content, 0, size);
                }
            }
            finally {
                stream.close(is);
                stream.close(os);
            }
        }

        public byte[] readFrom(File file) throws IOException {
            return this.readFrom((InputStream)new FileInputStream(file), (int)file.length());
        }

        public String readFrom(File file, String charsetName) throws IOException {
            byte[] content = this.readFrom((InputStream)new FileInputStream(file), (int)file.length());
            if (content.length >= 3 && "utf-8".equalsIgnoreCase(charsetName) && content[0] == -17 && content[1] == -69 && content[2] == -65) {
                return new String(content, 3, content.length - 3, charsetName);
            }
            return new String(content, charsetName);
        }

        public byte[] readFrom(InputStream is) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(16384);
            this.copy(is, baos, AutoClose.INPUT);
            return baos.toByteArray();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] readFrom(InputStream is, int expectedSize) throws IOException {
            byte[] content = new byte[expectedSize];
            try {
                int size;
                for (int count = 0; count < expectedSize; count += size) {
                    size = is.read(content, count, expectedSize - count);
                    if (size != -1) continue;
                    break;
                }
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            return content;
        }

        public String readFrom(InputStream is, String charsetName) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(16384);
            this.copy(is, baos, AutoClose.INPUT);
            return baos.toString(charsetName);
        }

        public String readUtf8String(InputStream is) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(16384);
            this.copy(is, baos, AutoClose.INPUT);
            return baos.toString("utf-8");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeTo(File file, byte[] data) throws IOException {
            if (file.isDirectory()) {
                throw new IOException(String.format("Can't write to an existing directory(%s)", file));
            }
            Dir.INSTANCE.createDir(file.getParentFile());
            FileOutputStream fos = new FileOutputStream(file);
            try {
                fos.write(data);
            }
            finally {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }

        public void writeTo(File file, String data) throws IOException {
            this.writeTo(file, data, "utf-8");
        }

        public void writeTo(File file, String data, String charsetName) throws IOException {
            this.writeTo(file, data.getBytes(charsetName));
        }
    }

    public static enum Dir {
        INSTANCE;


        public void copyDir(File from, File to) throws IOException {
            this.copyDir(from, to, null);
        }

        public void copyDir(File from, File to, Policy policy) throws IOException {
            String[] names = from.list();
            this.createDir(to);
            if (names != null) {
                for (String name : names) {
                    File file = new File(from, name);
                    if (policy != null && !policy.apply(file.getPath())) continue;
                    if (file.isDirectory()) {
                        this.copyDir(file, new File(to, name));
                        continue;
                    }
                    this.copyFile(file, new File(to, name));
                }
            }
        }

        public void copyFile(File from, File to) throws IOException {
            this.createDir(to.getParentFile());
            IO.INSTANCE.copy(new FileInputStream(from), new FileOutputStream(to), AutoClose.INPUT_OUTPUT);
            to.setLastModified(from.lastModified());
        }

        public void createDir(File dir) {
            if (!dir.exists() && !dir.mkdirs()) {
                throw new RuntimeException(String.format("Cant' create directory(%s)!", dir));
            }
        }

        public boolean delete(File file) {
            return this.delete(file, false);
        }

        public boolean delete(File file, boolean recursive) {
            if (file.exists()) {
                if (file.isFile()) {
                    return file.delete();
                }
                if (file.isDirectory()) {
                    File[] children;
                    if (recursive && (children = file.listFiles()) != null) {
                        for (File child : children) {
                            this.delete(child, recursive);
                        }
                    }
                    return file.delete();
                }
            }
            return false;
        }
    }

    public static enum AutoClose {
        NONE,
        INPUT,
        OUTPUT,
        INPUT_OUTPUT;


        public void close(InputStream is) {
            if ((this == INPUT || this == INPUT_OUTPUT) && is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public void close(OutputStream os) {
            if ((this == OUTPUT || this == INPUT_OUTPUT) && os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

