/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.helper;

import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Date;

public class Formats {
    public static NumberFormat forNumber() {
        return NumberFormat.INSTANCE;
    }

    public static ObjectFormat forObject() {
        return ObjectFormat.INSTANCE;
    }

    public static enum ObjectFormat {
        INSTANCE;


        public String shorten(String str, int maxLength) {
            int len;
            int n = len = str == null ? 0 : str.length();
            if (len < maxLength || len <= 3) {
                return str;
            }
            StringBuilder sb = new StringBuilder(maxLength);
            String dots = "...";
            int dotsLen = dots.length();
            int left = (maxLength - dotsLen) / 2;
            sb.append(str.substring(0, left));
            sb.append(dots);
            sb.append(str.substring(len - maxLength + left + dotsLen));
            return sb.toString();
        }

        public String format(Object data, String pattern) {
            if (pattern == null || pattern.length() == 0 || data == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder(32);
            sb.append("{0");
            if (pattern.startsWith("number") || pattern.startsWith("date") || pattern.startsWith("choice")) {
                sb.append(',').append(pattern);
            } else if (data instanceof Date) {
                sb.append(",date,").append(pattern);
            } else if (data instanceof Number) {
                sb.append(",number,").append(pattern);
            }
            sb.append('}');
            MessageFormat format = new MessageFormat(sb.toString());
            return format.format(new Object[]{data});
        }
    }

    public static enum NumberFormat {
        INSTANCE;


        public String percentage(double divisor, double divident, int precision) {
            if (divident == 1.0E-6) {
                return "N/A";
            }
            StringBuilder sb = new StringBuilder();
            sb.append('0');
            if (precision > 0) {
                sb.append('.');
                for (int i = 0; i < precision; ++i) {
                    sb.append('0');
                }
            }
            sb.append('%');
            return new DecimalFormat(sb.toString()).format(divisor / divident);
        }

        public String format(Number data, String pattern, String suffix) {
            boolean flag;
            char ch;
            if (pattern == null || pattern.length() == 0 || data == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder(32);
            long base = 1000L;
            if (suffix != null && suffix.length() > 0 && ((ch = suffix.charAt(0)) == 'B' || ch == 'b')) {
                base = 1024L;
            }
            sb.append("{0,number,").append(pattern);
            sb.append('}');
            double value = data.doubleValue();
            long scale1 = 1L;
            long scale2 = -1L;
            boolean bl = flag = value > 0.0;
            if (!flag) {
                value = -value;
            }
            while (value >= (double)base) {
                scale1 *= base;
                value /= (double)base;
            }
            if (value > 0.0 && value < 1.0 && base == 1000L) {
                while (value < 1.0) {
                    scale2 *= base;
                    value *= (double)base;
                }
            }
            if (scale1 != 1L) {
                if (scale1 == base) {
                    sb.append('K');
                } else if (scale1 == base * base) {
                    sb.append('M');
                } else if (scale1 == base * base * base) {
                    sb.append('G');
                } else if (scale1 == base * base * base * base) {
                    sb.append('T');
                } else if (scale1 == base * base * base * base * base) {
                    sb.append('P');
                }
            }
            if (scale2 != -1L) {
                if (scale2 == -base) {
                    sb.append('m');
                } else if (scale2 == -base * base) {
                    sb.append('u');
                } else if (scale2 == -base * base * base) {
                    sb.append('n');
                }
            }
            if (suffix != null) {
                sb.append(suffix);
            }
            MessageFormat format = new MessageFormat(sb.toString());
            return format.format(new Object[]{flag ? value : -value});
        }
    }
}

