/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.helper;

import java.util.HashMap;
import java.util.Map;

public class Matchers {
    public static StringMatcher forString() {
        return StringMatcher.CASE_SENSITIVE;
    }

    public static StringTrie forTrie() {
        return new StringTrie();
    }

    public static interface TrieHandler {
        public void handle(String var1, int var2, int var3, boolean var4, Object[] var5) throws Exception;
    }

    public static class StringTrie {
        private Map<Integer, TrieHandler> m_handlers = new HashMap<Integer, TrieHandler>();
        private byte[] m_flags = new byte[8192];

        public void addHandler(String part, TrieHandler handler, boolean prefixOrSuffix) {
            int key = this.hash(part, prefixOrSuffix);
            int size = this.m_flags.length;
            int index = key > 0 ? key : Integer.MAX_VALUE + key;
            this.m_handlers.put(key, handler);
            this.m_flags[index % size] = 1;
        }

        public boolean handle(String str, Object ... arguments) throws Exception {
            TrieHandler handler;
            int index;
            int i;
            int len = str == null ? 0 : str.length();
            int size = this.m_flags.length;
            int key = 0;
            TrieHandler last = null;
            int lastStart = 0;
            int lastEnd = len;
            boolean flag = true;
            for (i = 0; i < len; ++i) {
                int n = index = (key = key * 31 + str.charAt(i)) > 0 ? key : Integer.MAX_VALUE + key;
                if (this.m_flags[index % size] <= 0) continue;
                handler = this.m_handlers.get(key);
                if (handler != null) {
                    last = handler;
                    lastEnd = i + 1;
                    continue;
                }
                if (last != null) break;
            }
            if (last == null) {
                key = 0;
                lastEnd = len;
                flag = false;
                for (i = len - 1; i >= 0; --i) {
                    int n = index = (key = key * 31 + str.charAt(i)) > 0 ? key : Integer.MAX_VALUE + key;
                    if (this.m_flags[index % size] <= 0) continue;
                    handler = this.m_handlers.get(key);
                    if (handler != null) {
                        last = handler;
                        lastStart = i;
                        continue;
                    }
                    if (last != null) break;
                }
            }
            if (last != null) {
                last.handle(str, lastStart, lastEnd, flag, arguments);
                return true;
            }
            return false;
        }

        private int hash(String str, boolean flag) {
            int len = str == null ? 0 : str.length();
            int hash = 0;
            if (flag) {
                for (int i = 0; i < len; ++i) {
                    hash = hash * 31 + str.charAt(i);
                }
            } else {
                for (int i = len - 1; i >= 0; --i) {
                    hash = hash * 31 + str.charAt(i);
                }
            }
            return hash;
        }
    }

    public static enum StringMatcher {
        CASE_SENSITIVE(true),
        CASE_INSENSITIVE(false);

        private boolean m_caseSensitive;

        private StringMatcher(boolean caseSensitive) {
            this.m_caseSensitive = caseSensitive;
        }

        public StringMatcher caseSensitive(boolean caseSensitive) {
            if (caseSensitive) {
                return CASE_SENSITIVE;
            }
            return CASE_INSENSITIVE;
        }

        public StringMatcher ignoreCase() {
            return CASE_INSENSITIVE;
        }

        public boolean matches(String source, int start, String part) {
            return this.matches(source, start, part, 0, part.length());
        }

        public boolean matches(String source, int start, String part, int count) {
            return this.matches(source, start, part, 0, count);
        }

        public boolean matches(String source, int start, String part, int partStart, int count) {
            if (source == null || part == null) {
                throw new IllegalArgumentException(String.format("Source(%s) or part(%s) can't be null!", source, part));
            }
            return source.regionMatches(this.m_caseSensitive, start, part, 0, count);
        }
    }
}

