/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.lookup;

import java.util.List;
import java.util.Map;
import org.unidal.lookup.ComponentLookupException;
import org.unidal.lookup.LookupException;
import org.unidal.lookup.PlexusContainer;
import org.unidal.lookup.extension.Contextualizable;

public abstract class ContainerHolder
implements Contextualizable {
    private PlexusContainer m_container;

    @Override
    public void contextualize(Map<String, Object> context) {
        this.m_container = (PlexusContainer)context.get("plexus");
    }

    protected PlexusContainer getContainer() {
        return this.m_container;
    }

    protected <T> boolean hasComponent(Class<T> role) {
        return this.hasComponent(role, null);
    }

    protected <T> boolean hasComponent(Class<T> role, String roleHint) {
        return this.getContainer().hasComponent(role, roleHint);
    }

    protected <T> T lookup(Class<T> role) throws LookupException {
        return this.lookup(role, null);
    }

    protected <T> T lookup(Class<T> role, String roleHint) throws LookupException {
        try {
            return this.getContainer().lookup(role, roleHint == null ? "default" : roleHint);
        }
        catch (ComponentLookupException e) {
            String key = role.getName() + ":" + (roleHint == null ? "default" : roleHint);
            throw new LookupException("Unable to lookup component(" + key + ").", e);
        }
    }

    protected <T> List<T> lookupList(Class<T> role) throws LookupException {
        try {
            return this.getContainer().lookupList(role);
        }
        catch (ComponentLookupException e) {
            String key = role.getName();
            throw new LookupException("Unable to lookup component list(" + key + ").", e);
        }
    }

    protected <T> Map<String, T> lookupMap(Class<T> role) throws LookupException {
        try {
            return this.getContainer().lookupMap(role);
        }
        catch (ComponentLookupException e) {
            String key = role.getName();
            throw new LookupException("Unable to lookup component map(" + key + ").", e);
        }
    }

    protected void release(Object component) throws LookupException {
        if (component != null) {
            this.getContainer().release(component);
        }
    }
}

