/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.lookup;

import java.io.InputStream;
import org.unidal.lookup.PlexusContainer;
import org.unidal.lookup.container.MyPlexusContainer;

public class ContainerLoader {
    private static volatile PlexusContainer s_container;

    public static void destroy() {
        if (s_container != null) {
            s_container.dispose();
            s_container = null;
        }
    }

    public static PlexusContainer getDefaultContainer() {
        return ContainerLoader.getDefaultContainer(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PlexusContainer getDefaultContainer(String configuration) {
        if (s_container != null) return s_container;
        Class<ContainerLoader> clazz = ContainerLoader.class;
        synchronized (ContainerLoader.class) {
            if (s_container != null) return s_container;
            try {
                if (configuration != null) {
                    InputStream in = ContainerLoader.class.getClassLoader().getResourceAsStream(configuration);
                    s_container = new MyPlexusContainer(in);
                } else {
                    s_container = new MyPlexusContainer();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create Plexus container!", e);
            }
            return s_container;
        }
    }

    static class Key {
        private Class<?> m_role;
        private String m_roleHint;
        private String m_id;

        public Key(Class<?> role, String roleHint, String id) {
            this.m_role = role;
            this.m_roleHint = roleHint == null ? "default" : roleHint;
            this.m_id = id;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                Key e = (Key)obj;
                if (e.m_role != this.m_role) {
                    return false;
                }
                if (!e.m_roleHint.equals(this.m_roleHint)) {
                    return false;
                }
                return e.m_id.equals(this.m_id);
            }
            return false;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = hashCode * 31 + this.m_role.hashCode();
            hashCode = hashCode * 31 + this.m_roleHint.hashCode();
            hashCode = hashCode * 31 + this.m_id.hashCode();
            return hashCode;
        }
    }
}

