/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.lookup.container;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.unidal.helper.Files;
import org.unidal.helper.Scanners;
import org.unidal.lookup.container.ComponentKey;
import org.unidal.lookup.container.model.entity.ComponentModel;
import org.unidal.lookup.container.model.entity.PlexusModel;
import org.unidal.lookup.container.model.transform.DefaultSaxParser;
import org.xml.sax.SAXException;

public class ComponentModelManager {
    private List<PlexusModel> m_models = new ArrayList<PlexusModel>();
    private PlexusModel m_model = new PlexusModel();
    private Map<ComponentKey, ComponentModel> m_cache = new HashMap<ComponentKey, ComponentModel>();

    public ComponentModelManager() {
        this.m_models.add(this.m_model);
    }

    public void addComponent(ComponentModel component) {
        this.m_model.addComponent(component);
    }

    public ComponentModel getComponentModel(ComponentKey key) {
        ComponentModel model = this.m_cache.get(key);
        boolean found = false;
        if (!found) {
            for (ComponentModel component : this.m_model.getComponents()) {
                if (!key.matches(component.getRole(), component.getHint())) continue;
                model = component;
                found = true;
                this.m_cache.put(key, component);
                break;
            }
        }
        if (!found) {
            for (PlexusModel plexus : this.m_models) {
                for (ComponentModel component : plexus.getComponents()) {
                    if (!key.matches(component.getRole(), component.getHint())) continue;
                    model = component;
                    found = true;
                    this.m_cache.put(key, component);
                    break;
                }
                if (!found) continue;
                break;
            }
        }
        return model;
    }

    public List<String> getRoleHints(String role) {
        ArrayList<String> roleHints = new ArrayList<String>();
        HashSet<String> done = new HashSet<String>();
        for (PlexusModel model : this.m_models) {
            for (ComponentModel component : model.getComponents()) {
                String roleHint;
                if (!role.equals(component.getRole()) || done.contains(roleHint = component.getHint())) continue;
                done.add(roleHint);
                roleHints.add(roleHint);
            }
        }
        return roleHints;
    }

    public boolean hasComponentModel(ComponentKey key) {
        return this.getComponentModel(key) != null;
    }

    private void loadCompoents(URL url) throws IOException, SAXException {
        if (url.getPath().contains("/plexus-container-default/")) {
            return;
        }
        InputStream in = url.openStream();
        String xml = Files.forIO().readFrom(in, "utf-8");
        if (xml != null && xml.contains("<component-set>")) {
            xml = xml.replace("<component-set>", "<plexus>");
            xml = xml.replace("</component-set>", "</plexus>");
        }
        try {
            PlexusModel model = DefaultSaxParser.parse(xml);
            this.m_models.add(model);
        }
        catch (SAXException e) {
            System.err.println(String.format("Bad plexus resource(%s): ", url) + xml);
            throw e;
        }
    }

    public void loadComponents(InputStream in) throws Exception {
        if (in != null) {
            try {
                PlexusModel model = DefaultSaxParser.parse(in);
                this.m_models.add(model);
            }
            finally {
                in.close();
            }
        }
    }

    public void loadComponentsFromClasspath() throws Exception {
        List<URL> urls = this.scanComponents();
        for (URL url : urls) {
            this.loadCompoents(url);
        }
    }

    public void reset() {
        this.m_model.getComponents().clear();
    }

    List<URL> scanComponents() throws IOException {
        final ArrayList<URL> components = new ArrayList<URL>();
        Scanners.forResource().scan("META-INF/plexus", new Scanners.ResourceMatcher(){

            @Override
            public Scanners.IMatcher.Direction matches(URL base, String path) {
                if (!path.endsWith(".xml")) {
                    return Scanners.IMatcher.Direction.DOWN;
                }
                if (path.contains("/plexus-container-default/")) {
                    return Scanners.IMatcher.Direction.NEXT;
                }
                if (path.equals("plexus.xml") || path.equals("components.xml") || path.startsWith("components-")) {
                    try {
                        String baseUrl = base.toExternalForm();
                        String url = baseUrl.endsWith("/") ? baseUrl + path : baseUrl + "/" + path;
                        components.add(new URL(url));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return Scanners.IMatcher.Direction.DOWN;
            }
        });
        return components;
    }

    public void setComponentModel(ComponentKey key, Class<?> clazz) {
        for (PlexusModel model : this.m_models) {
            ComponentModel component = new ComponentModel().setRole(key.getRole()).setRoleHint(key.getRoleHint()).setImplementation(clazz.getName());
            model.addComponent(component);
        }
    }
}

