/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.lookup.logging;

import org.unidal.lookup.logging.Logger;

public abstract class AbstractLogger
implements Logger {
    private int m_threshold;
    private String m_name;

    public AbstractLogger(int threshold, String name) {
        if (!this.isValidThreshold(threshold)) {
            throw new IllegalArgumentException("Threshold " + threshold + " is not valid");
        }
        this.m_threshold = threshold;
        this.m_name = name;
    }

    @Override
    public void debug(String message) {
        this.debug(message, null);
    }

    @Override
    public void error(String message) {
        this.error(message, null);
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public int getThreshold() {
        return this.m_threshold;
    }

    @Override
    public void info(String message) {
        this.info(message, null);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.m_threshold <= 0;
    }

    @Override
    public boolean isErrorEnabled() {
        return this.m_threshold <= 3;
    }

    @Override
    public boolean isInfoEnabled() {
        return this.m_threshold <= 1;
    }

    protected boolean isValidThreshold(int threshold) {
        if (threshold == 0) {
            return true;
        }
        if (threshold == 1) {
            return true;
        }
        if (threshold == 2) {
            return true;
        }
        if (threshold == 3) {
            return true;
        }
        return threshold == 4;
    }

    @Override
    public boolean isWarnEnabled() {
        return this.m_threshold <= 2;
    }

    @Override
    public void setThreshold(int threshold) {
        this.m_threshold = threshold;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void warn(String message) {
        this.warn(message, null);
    }
}

