/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.lookup.logging;

import java.io.File;
import java.net.URL;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import org.unidal.helper.Properties;
import org.unidal.lookup.extension.Initializable;
import org.unidal.lookup.extension.InitializationException;
import org.unidal.lookup.logging.AbstractLogger;
import org.unidal.lookup.logging.AbstractLoggerManager;
import org.unidal.lookup.logging.LoggerManager;

public class Log4jLoggerManager
extends AbstractLoggerManager
implements LoggerManager,
Initializable {
    private String m_configurationFile = "log4j.xml";
    private String m_baseDirRef;

    @Override
    protected AbstractLogger createLogger(String name) {
        Logger logger = LogManager.getLogger((String)name);
        LevelAdapter level = new LevelAdapter(logger.getLevel());
        return new LoggerAdapter(logger, level.getThreshold());
    }

    @Override
    public void initialize() throws InitializationException {
        String baseDir = Properties.forString().fromSystem().fromEnv().getProperty(this.m_baseDirRef, null);
        boolean loaded = false;
        if (baseDir != null) {
            loaded = this.tryLoadingFromFile(baseDir);
        }
        if (!loaded) {
            loaded = this.tryLoadingFromResource();
        }
        if (!loaded) {
            LogManager.getLogger((String)this.getClass().getName()).warn((Object)String.format("No configuration(%s) was found with baseDirRef(%s)!", this.m_configurationFile, this.m_baseDirRef));
        }
    }

    public void setBaseDirRef(String baseDirRef) {
        this.m_baseDirRef = baseDirRef;
    }

    public void setConfigurationFile(String configurationFile) {
        this.m_configurationFile = configurationFile;
    }

    private boolean tryLoadingFromFile(String baseDir) throws FactoryConfigurationError {
        File file;
        if (this.m_configurationFile.endsWith(".xml")) {
            File file2 = new File(baseDir, this.m_configurationFile);
            if (file2.exists()) {
                DOMConfigurator.configure((String)file2.getAbsolutePath());
                return true;
            }
        } else if (this.m_configurationFile.endsWith(".properties") && (file = new File(baseDir, this.m_configurationFile)).exists()) {
            PropertyConfigurator.configure((String)file.getAbsolutePath());
            return true;
        }
        return false;
    }

    private boolean tryLoadingFromResource() throws FactoryConfigurationError {
        URL url;
        if (this.m_configurationFile.endsWith(".xml")) {
            URL url2 = this.getClass().getResource(this.m_configurationFile);
            if (url2 != null) {
                DOMConfigurator.configure((URL)url2);
                return true;
            }
        } else if (this.m_configurationFile.endsWith(".properties") && (url = this.getClass().getResource(this.m_configurationFile)) != null) {
            PropertyConfigurator.configure((URL)url);
            return true;
        }
        return false;
    }

    static class LoggerAdapter
    extends AbstractLogger {
        private Logger m_logger;

        public LoggerAdapter(Logger logger, int threshold) {
            super(threshold, logger.getName());
            this.m_logger = logger;
        }

        @Override
        public void debug(String message, Throwable t) {
            if (this.isDebugEnabled()) {
                this.m_logger.debug((Object)message, t);
            }
        }

        @Override
        public void error(String message, Throwable t) {
            if (this.isErrorEnabled()) {
                this.m_logger.error((Object)message, t);
            }
        }

        @Override
        public void info(String message, Throwable t) {
            if (this.isInfoEnabled()) {
                this.m_logger.info((Object)message, t);
            }
        }

        @Override
        public void warn(String message, Throwable t) {
            if (this.isWarnEnabled()) {
                this.m_logger.warn((Object)message, t);
            }
        }
    }

    static class LevelAdapter {
        private int m_threshold = 0;

        public LevelAdapter(Level level) {
            if (level != null) {
                switch (level.toInt()) {
                    case 10000: {
                        this.m_threshold = 0;
                        break;
                    }
                    case 20000: {
                        this.m_threshold = 1;
                        break;
                    }
                    case 30000: {
                        this.m_threshold = 2;
                        break;
                    }
                    case 40000: {
                        this.m_threshold = 3;
                    }
                }
            }
        }

        public int getThreshold() {
            return this.m_threshold;
        }
    }
}

