/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.lookup.logging;

import java.text.MessageFormat;
import java.util.Date;
import org.unidal.helper.Threads;
import org.unidal.lookup.logging.AbstractLogger;
import org.unidal.lookup.logging.Logger;
import org.unidal.lookup.logging.TimedConsoleLoggerManager;

public class TimedConsoleLogger
extends AbstractLogger
implements Logger {
    private MessageFormat m_format;
    private boolean m_showClass;

    public TimedConsoleLogger(int threshold, String name, String dateFormat, boolean showClass) {
        super(threshold, name);
        String pattern = showClass ? "[{0,date," + dateFormat + "}] [{1}] [{3}] {2}" : "[{0,date," + dateFormat + "}] [{1}] {2}";
        this.m_showClass = showClass;
        this.m_format = new MessageFormat(pattern);
    }

    @Override
    public void debug(String message, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.out("DEBUG", message, throwable);
        }
    }

    @Override
    public void error(String message, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.out("ERROR", message, throwable);
        }
    }

    private String getCallerClassName() {
        String caller = Threads.getCallerClass();
        if (caller != null) {
            return caller;
        }
        StackTraceElement[] elements = new Exception().getStackTrace();
        if (elements.length > 5) {
            for (int i = 5; i < elements.length; ++i) {
                String className = elements[i].getClassName();
                if (TimedConsoleLoggerManager.shouldSkipClass(className)) continue;
                int pos = className.lastIndexOf(36);
                if (pos < 0) {
                    pos = className.lastIndexOf(46);
                }
                if (pos > 0) {
                    return className.substring(pos + 1);
                }
                return className;
            }
        }
        return "N/A";
    }

    private String getTimedMessage(String level, String message) {
        if (this.m_showClass) {
            return this.m_format.format(new Object[]{new Date(), level, message, this.getCallerClassName()});
        }
        return this.m_format.format(new Object[]{new Date(), level, message});
    }

    @Override
    public void info(String message, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.out("INFO", message, throwable);
        }
    }

    private void out(String severity, String message, Throwable throwable) {
        String timedMessage = this.getTimedMessage(severity, message);
        System.out.println(timedMessage);
        if (throwable != null) {
            throwable.printStackTrace(System.out);
        }
    }

    @Override
    public void warn(String message, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.out("WARN", message, throwable);
        }
    }
}

