/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.converter.basic;

import java.lang.reflect.Type;
import org.unidal.webres.converter.Converter;
import org.unidal.webres.converter.ConverterContext;
import org.unidal.webres.converter.ConverterException;
import org.unidal.webres.converter.TypeUtil;

public class CharConverter
implements Converter<Character> {
    @Override
    public boolean canConvert(ConverterContext ctx) {
        return TypeUtil.isClassSupported(ctx.getSourceClass(), Number.class, Boolean.TYPE, Boolean.class, String.class, Enum.class);
    }

    @Override
    public Character convert(ConverterContext ctx) throws ConverterException {
        Object from = ctx.getSource();
        if (from instanceof Number) {
            return Character.valueOf((char)(((Number)from).intValue() & 0xFFFF));
        }
        if (from instanceof Boolean) {
            return Character.valueOf((Boolean)from != false ? (char)'1' : '0');
        }
        if (from instanceof Enum) {
            return Character.valueOf((char)((Enum)from).ordinal());
        }
        String str = from.toString().trim();
        if (str.length() > 0) {
            return Character.valueOf(str.charAt(0));
        }
        return Character.valueOf('\u0000');
    }

    @Override
    public Type getTargetType() {
        return Character.class;
    }
}

