/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.converter.basic;

import java.lang.reflect.Type;
import org.unidal.webres.converter.Converter;
import org.unidal.webres.converter.ConverterContext;
import org.unidal.webres.converter.ConverterException;
import org.unidal.webres.converter.TypeUtil;

public class DoubleConverter
implements Converter<Double> {
    @Override
    public boolean canConvert(ConverterContext ctx) {
        return TypeUtil.isClassSupported(ctx.getSourceClass(), Number.class, Boolean.TYPE, Boolean.class, String.class, Enum.class);
    }

    @Override
    public Double convert(ConverterContext ctx) throws ConverterException {
        Object from = ctx.getSource();
        if (from instanceof Number) {
            return ((Number)from).doubleValue();
        }
        if (from instanceof Boolean) {
            return (Boolean)from != false ? Double.valueOf(1.0) : 0.0;
        }
        if (from instanceof Enum) {
            return ((Enum)from).ordinal();
        }
        try {
            return Double.valueOf(from.toString().trim());
        }
        catch (NumberFormatException e) {
            throw new ConverterException(e);
        }
    }

    @Override
    public Type getTargetType() {
        return Double.class;
    }
}

