/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.converter.collection;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.unidal.webres.converter.Converter;
import org.unidal.webres.converter.ConverterContext;
import org.unidal.webres.converter.ConverterException;
import org.unidal.webres.converter.ConverterFatalException;
import org.unidal.webres.converter.TypeUtil;

public class ListConverter<T>
implements Converter<List<T>> {
    @Override
    public boolean canConvert(ConverterContext ctx) {
        Class<?> fromClass = ctx.getSourceClass();
        if (fromClass.isArray()) {
            return true;
        }
        return List.class.isAssignableFrom(fromClass);
    }

    @Override
    public List<T> convert(ConverterContext ctx) throws ConverterException {
        ArrayList<Object> list;
        Class<?> clazz = ctx.getSourceClass();
        Type componentType = TypeUtil.getComponentType(ctx.getTargetType());
        Object from = ctx.getSource();
        if (clazz.isArray()) {
            int length = Array.getLength(from);
            list = new ArrayList<Object>(length);
            int i = 0;
            while (i < length) {
                Object item = Array.get(from, i);
                Object element = ctx.getManager().convert(item, componentType, true);
                list.add(element);
                ++i;
            }
        } else if (List.class.isAssignableFrom(clazz)) {
            List fromList = (List)from;
            list = new ArrayList(fromList.size());
            for (Object item : fromList) {
                Object element = ctx.getManager().convert(item, componentType, true);
                list.add(element);
            }
        } else {
            throw new ConverterFatalException("Unknown type: " + from.getClass(), this.getClass());
        }
        return list;
    }

    @Override
    public Type getTargetType() {
        return List.class;
    }
}

