/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.converter.node;

import java.lang.reflect.Type;
import org.unidal.webres.converter.Converter;
import org.unidal.webres.converter.ConverterContext;
import org.unidal.webres.converter.ConverterException;
import org.unidal.webres.dom.INode;
import org.unidal.webres.dom.NodeType;
import org.unidal.webres.dom.TagNode;
import org.unidal.webres.dom.TextNode;

public class TagNodeValueConverter
implements Converter<String> {
    @Override
    public boolean canConvert(ConverterContext ctx) {
        return INode.class.isAssignableFrom(ctx.getSourceClass());
    }

    @Override
    public String convert(ConverterContext ctx) throws ConverterException {
        INode node = (INode)ctx.getSource();
        switch (node.getNodeType()) {
            case TAG: {
                INode child;
                TagNode tagNode = (TagNode)node;
                if (tagNode.getChildNodes().size() != 1 || (child = tagNode.getFirstChild()) == null || child.getNodeType() != NodeType.TEXT) break;
                return ((TextNode)child).getNodeValue();
            }
            case TEXT: {
                return ((TextNode)node).getNodeValue();
            }
        }
        throw ConverterContext.SKIP;
    }

    @Override
    public Type getTargetType() {
        return String.class;
    }
}

