/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.unidal.webres.dom.BaseNode;
import org.unidal.webres.dom.INode;
import org.unidal.webres.dom.ITagNode;
import org.unidal.webres.dom.NodeType;
import org.unidal.webres.dom.TextNode;

public class TagNode
extends BaseNode
implements ITagNode {
    private String m_nodeName;
    private List<INode> m_childNodes;
    private Map<String, String> m_attributes;

    public TagNode(String name, ITagNode parent) {
        super(parent);
        this.m_nodeName = name;
    }

    @Override
    public void add(INode node) {
        if (node.getParent() != null) {
            ((TagNode)node.getParent()).remove(node);
        }
        if (this.m_childNodes == null) {
            this.m_childNodes = new ArrayList<INode>();
        }
        this.m_childNodes.add(node);
        ((BaseNode)node).setParent(this);
    }

    @Override
    public void appendText(String text) {
        INode lastChild;
        if (this.m_childNodes != null && this.m_childNodes.size() > 0 && (lastChild = this.m_childNodes.get(this.m_childNodes.size() - 1)).getNodeType() == NodeType.TEXT) {
            lastChild.appendText(text);
            return;
        }
        new TextNode(text, this);
    }

    @Override
    protected void asString(StringBuilder sb) {
        sb.append('<').append(this.m_nodeName);
        if (this.m_attributes != null) {
            for (Map.Entry<String, String> e : this.m_attributes.entrySet()) {
                sb.append(' ').append(e.getKey());
                sb.append("=\"").append(this.encode(e.getValue())).append('\"');
            }
        }
        sb.append('>');
        if (this.m_childNodes != null) {
            for (INode child : this.m_childNodes) {
                if (child instanceof BaseNode) {
                    ((BaseNode)child).asString(sb);
                    continue;
                }
                sb.append(child);
            }
        }
        sb.append("</").append(this.m_nodeName).append('>');
    }

    @Override
    public String getAttribute(String name) {
        if (this.m_attributes != null) {
            return this.m_attributes.get(name);
        }
        return null;
    }

    @Override
    public Map<String, String> getAttributes() {
        if (this.m_attributes == null) {
            return Collections.emptyMap();
        }
        return this.m_attributes;
    }

    @Override
    public List<INode> getChildNodes() {
        if (this.m_childNodes == null) {
            return Collections.emptyList();
        }
        return this.m_childNodes;
    }

    @Override
    public ITagNode getChildTagNode(String childTagName) {
        if (this.m_childNodes != null) {
            for (INode node : this.m_childNodes) {
                ITagNode tag;
                if (node.getNodeType() == NodeType.TEXT || !(tag = (ITagNode)node).getNodeName().equals(childTagName)) continue;
                return tag;
            }
        }
        return null;
    }

    @Override
    public List<ITagNode> getChildTagNodes() {
        if (this.m_childNodes == null) {
            return Collections.emptyList();
        }
        ArrayList<ITagNode> nodes = new ArrayList<ITagNode>(this.m_childNodes.size());
        for (INode node : this.m_childNodes) {
            if (node.getNodeType() == NodeType.TEXT) continue;
            nodes.add((ITagNode)node);
        }
        return nodes;
    }

    @Override
    public List<ITagNode> getChildTagNodes(String childTagName) {
        if (this.m_childNodes == null) {
            return Collections.emptyList();
        }
        ArrayList<ITagNode> nodes = new ArrayList<ITagNode>(this.m_childNodes.size());
        for (INode node : this.m_childNodes) {
            ITagNode tag;
            if (node.getNodeType() == NodeType.TEXT || !(tag = (ITagNode)node).getNodeName().equals(childTagName)) continue;
            nodes.add(tag);
        }
        return nodes;
    }

    @Override
    public INode getFirstChild() {
        if (this.hasChildNodes()) {
            return this.m_childNodes.get(0);
        }
        return null;
    }

    @Override
    public List<ITagNode> getGrandchildTagNodes(String childTagName) {
        ITagNode childTag = this.getChildTagNode(childTagName);
        if (childTag == null) {
            return Collections.emptyList();
        }
        return childTag.getChildTagNodes();
    }

    @Override
    public INode getLastChild() {
        if (this.hasChildNodes()) {
            return this.m_childNodes.get(this.m_childNodes.size() - 1);
        }
        return null;
    }

    @Override
    public String getNodeName() {
        return this.m_nodeName;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.TAG;
    }

    @Override
    public boolean hasAttributes() {
        return this.m_attributes != null && !this.m_attributes.isEmpty();
    }

    @Override
    public boolean hasChildNodes() {
        return this.m_childNodes != null && !this.m_childNodes.isEmpty();
    }

    @Override
    public void remove(INode node) {
        if (this.hasChildNodes() && this.getChildNodes().remove(node)) {
            ((BaseNode)node).setParent(null);
        }
    }

    @Override
    public void setAttribute(String name, String value) {
        if (this.m_attributes == null) {
            this.m_attributes = new LinkedHashMap<String, String>();
        }
        this.m_attributes.put(name, value);
    }
}

