/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.helper;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Files {
    public static Dir forDir() {
        return Dir.INSTANCE;
    }

    public static IO forIO() {
        return IO.INSTANCE;
    }

    public static Zip forZip() {
        return Zip.INSTANCE;
    }

    public static enum AutoClose {
        NONE,
        INPUT,
        OUTPUT,
        INPUT_OUTPUT;


        public void close(InputStream is) {
            if ((this == INPUT || this == INPUT_OUTPUT) && is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public void close(OutputStream os) {
            if ((this == OUTPUT || this == INPUT_OUTPUT) && os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static enum Dir {
        INSTANCE;


        public void copyDir(File from, File to) throws IOException {
            String[] names = from.list();
            this.createDir(to);
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                File file = new File(from, name);
                if (file.isDirectory()) {
                    this.copyDir(file, new File(to, name));
                } else {
                    this.copyFile(file, new File(to, name));
                }
                ++n2;
            }
        }

        public void copyFile(File from, File to) throws IOException {
            FileInputStream in = null;
            FileOutputStream out = null;
            try {
                in = new FileInputStream(from);
                out = new FileOutputStream(to);
            }
            catch (IOException e) {
                AutoClose.INPUT.close(in);
                throw e;
            }
            IO.INSTANCE.copy(in, out, AutoClose.INPUT_OUTPUT);
            to.setLastModified(from.lastModified());
        }

        public void createDir(File dir) {
            if (!dir.exists() && !dir.mkdirs()) {
                throw new RuntimeException(String.format("Cant' create directory(%s)!", dir));
            }
        }

        public boolean delete(File file) {
            return this.delete(file, false);
        }

        public boolean delete(File file, boolean recursive) {
            if (file.exists()) {
                if (file.isFile()) {
                    return file.delete();
                }
                if (file.isDirectory()) {
                    File[] children;
                    if (recursive && (children = file.listFiles()) != null) {
                        File[] fileArray = children;
                        int n = children.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File child = fileArray[n2];
                            this.delete(child, recursive);
                            ++n2;
                        }
                    }
                    return file.delete();
                }
            }
            return false;
        }
    }

    public static enum IO {
        INSTANCE;


        public void copy(InputStream is, OutputStream os) throws IOException {
            this.copy(is, os, AutoClose.NONE);
        }

        public void copy(InputStream is, OutputStream os, AutoClose stream) throws IOException {
            byte[] content = new byte[4096];
            try {
                int size;
                while ((size = is.read(content)) != -1) {
                    os.write(content, 0, size);
                }
            }
            finally {
                stream.close(is);
                stream.close(os);
            }
        }

        public byte[] readFrom(File file) throws IOException {
            int length = (int)file.length();
            return this.readFrom((InputStream)new FileInputStream(file), length);
        }

        public String readFrom(File file, String charsetName) throws IOException {
            int length = (int)file.length();
            byte[] content = this.readFrom((InputStream)new FileInputStream(file), length);
            return new String(content, charsetName);
        }

        public byte[] readFrom(InputStream is) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(16384);
            this.copy(is, baos, AutoClose.INPUT);
            return baos.toByteArray();
        }

        public byte[] readFrom(InputStream is, AutoClose close) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(16384);
            this.copy(is, baos, close);
            return baos.toByteArray();
        }

        public byte[] readFrom(InputStream is, int expectedSize) throws IOException {
            byte[] content = new byte[expectedSize];
            try {
                int count = 0;
                while (count < expectedSize) {
                    int size = is.read(content, count, expectedSize - count);
                    if (size == -1) {
                        break;
                    }
                    count += size;
                }
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            return content;
        }

        public String readFrom(InputStream is, String charsetName) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(16384);
            this.copy(is, baos, AutoClose.INPUT);
            return baos.toString(charsetName);
        }

        public void writeTo(File file, byte[] data) throws IOException {
            if (file.isDirectory()) {
                throw new IOException(String.format("Can't write to an existing directory(%s)", file));
            }
            File parent = file.getCanonicalFile().getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                throw new IOException(String.format("Can't create directory(%s)!", parent));
            }
            FileOutputStream fos = new FileOutputStream(file);
            try {
                fos.write(data);
            }
            finally {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }

        public void writeTo(File file, String data) throws IOException {
            this.writeTo(file, data, "utf-8");
        }

        public void writeTo(File file, String data, String charsetName) throws IOException {
            this.writeTo(file, data.getBytes(charsetName));
        }
    }

    public static enum Zip {
        INSTANCE;


        public List<String> copyDir(ZipInputStream zis, File baseDir) throws IOException {
            ZipEntry entry;
            ArrayList<String> entryNames = new ArrayList<String>();
            if (!baseDir.exists()) {
                Dir.INSTANCE.createDir(baseDir);
            }
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    Dir.INSTANCE.createDir(new File(baseDir, entry.getName()));
                    continue;
                }
                IO.INSTANCE.copy(zis, new FileOutputStream(new File(baseDir, entry.getName())), AutoClose.OUTPUT);
            }
            return entryNames;
        }
    }
}

