/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.helper;

import java.util.ArrayList;
import java.util.List;

public class Splitters {
    public static StringSplitter by(char delimiter) {
        return new StringSplitter(delimiter);
    }

    public static StringSplitter by(String delimiter) {
        return new StringSplitter(delimiter);
    }

    public static class StringSplitter {
        private char m_charDelimiter;
        private String m_stringDelimiter;
        private boolean m_trimmed;
        private boolean m_noEmptyItem;

        StringSplitter(char delimiter) {
            this.m_charDelimiter = delimiter;
        }

        StringSplitter(String delimiter) {
            this.m_stringDelimiter = delimiter;
        }

        protected List<String> doCharSplit(String str, List<String> list) {
            char delimiter = this.m_charDelimiter;
            int len = str.length();
            StringBuilder sb = new StringBuilder(len);
            int i = 0;
            while (i < len + 1) {
                char ch;
                char c = ch = i == len ? delimiter : str.charAt(i);
                if (ch == delimiter) {
                    String item = sb.toString();
                    sb.setLength(0);
                    if (this.m_trimmed) {
                        item = item.trim();
                    }
                    if (!this.m_noEmptyItem || item.length() != 0) {
                        list.add(item);
                    }
                } else {
                    sb.append(ch);
                }
                ++i;
            }
            return list;
        }

        protected List<String> doStringSplit(String source, List<String> list) {
            String delimiter = this.m_stringDelimiter;
            int len = delimiter.length();
            int offset = 0;
            int index = source.indexOf(delimiter, offset);
            while (true) {
                String part = index == -1 ? source.substring(offset) : source.substring(offset, index);
                if (this.m_trimmed) {
                    part = part.trim();
                }
                if (!this.m_noEmptyItem || part.length() > 0) {
                    list.add(part);
                }
                if (index == -1) break;
                offset = index + len;
                index = source.indexOf(delimiter, offset);
            }
            return list;
        }

        public StringSplitter noEmptyItem() {
            this.m_noEmptyItem = true;
            return this;
        }

        public List<String> split(String str) {
            return this.split(str, new ArrayList<String>());
        }

        public List<String> split(String str, List<String> list) {
            if (str == null) {
                return null;
            }
            if (this.m_charDelimiter > '\u0000') {
                return this.doCharSplit(str, list);
            }
            if (this.m_stringDelimiter != null) {
                return this.doStringSplit(str, list);
            }
            throw new UnsupportedOperationException();
        }

        public StringSplitter trim() {
            this.m_trimmed = true;
            return this;
        }
    }
}

