/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.json.serializer;

import org.unidal.webres.json.SerializationException;
import org.unidal.webres.json.serializer.AbstractSerializer;
import org.unidal.webres.json.serializer.ObjectMatch;
import org.unidal.webres.json.serializer.SerializerState;

public class PrimitiveSerializer
extends AbstractSerializer {
    private static Class<?>[] s_serializableClasses = new Class[]{Integer.TYPE, Byte.TYPE, Short.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    private static Class<?>[] s_JSONClasses = new Class[]{Integer.class, Byte.class, Short.class, Long.class, Float.class, Double.class, String.class};

    @Override
    public Class<?>[] getSerializableClasses() {
        return s_serializableClasses;
    }

    @Override
    public Class<?>[] getJSONClasses() {
        return s_JSONClasses;
    }

    @Override
    public ObjectMatch tryUnmarshall(SerializerState state, Class<?> clazz, Object jso) throws SerializationException {
        try {
            this.toPrimitive(clazz, jso);
        }
        catch (NumberFormatException e) {
            throw new SerializationException("not a primitive");
        }
        return ObjectMatch.OKAY;
    }

    public Object toPrimitive(Class<?> clazz, Object jso) throws NumberFormatException {
        if (Integer.TYPE.equals(clazz)) {
            if (jso instanceof String) {
                return new Integer((String)jso);
            }
            return new Integer(((Number)jso).intValue());
        }
        if (Long.TYPE.equals(clazz)) {
            if (jso instanceof String) {
                return new Long((String)jso);
            }
            return new Long(((Number)jso).longValue());
        }
        if (Short.TYPE.equals(clazz)) {
            if (jso instanceof String) {
                return new Short((String)jso);
            }
            return new Short(((Number)jso).shortValue());
        }
        if (Byte.TYPE.equals(clazz)) {
            if (jso instanceof String) {
                return new Byte((String)jso);
            }
            return new Byte(((Number)jso).byteValue());
        }
        if (Float.TYPE.equals(clazz)) {
            if (jso instanceof String) {
                return new Float((String)jso);
            }
            return new Float(((Number)jso).floatValue());
        }
        if (Double.TYPE.equals(clazz)) {
            if (jso instanceof String) {
                return new Double((String)jso);
            }
            return new Double(((Number)jso).doubleValue());
        }
        return null;
    }

    @Override
    public Object unmarshall(SerializerState state, Class<?> clazz, Object jso) throws SerializationException {
        try {
            return this.toPrimitive(clazz, jso);
        }
        catch (NumberFormatException nfe) {
            throw new SerializationException("cannot convert object " + jso + " to type " + clazz.getName());
        }
    }

    @Override
    public Object marshall(SerializerState state, Object o) throws SerializationException {
        return o;
    }
}

