/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.json.serializer;

import java.io.UnsupportedEncodingException;
import org.unidal.webres.json.SerializationException;
import org.unidal.webres.json.serializer.AbstractSerializer;
import org.unidal.webres.json.serializer.ObjectMatch;
import org.unidal.webres.json.serializer.SerializerState;

public class StringSerializer
extends AbstractSerializer {
    private static Class<?>[] s_serializableClasses = new Class[]{String.class, Character.TYPE, Character.class, byte[].class, char[].class};
    private static Class<?>[] s_JSONClasses = new Class[]{String.class, Integer.class};

    @Override
    public Class<?>[] getSerializableClasses() {
        return s_serializableClasses;
    }

    @Override
    public Class<?>[] getJSONClasses() {
        return s_JSONClasses;
    }

    @Override
    public ObjectMatch tryUnmarshall(SerializerState state, Class<?> clazz, Object jso) throws SerializationException {
        return ObjectMatch.OKAY;
    }

    @Override
    public Object unmarshall(SerializerState state, Class<?> clazz, Object jso) throws SerializationException {
        String val;
        String string = val = jso instanceof String ? (String)jso : jso.toString();
        if (clazz == Character.TYPE) {
            return new Character(val.charAt(0));
        }
        if (clazz == byte[].class) {
            try {
                return val.getBytes("utf-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new SerializationException("UnsupportedEncodingException");
            }
        }
        if (clazz == char[].class) {
            return val.toCharArray();
        }
        return val;
    }

    @Override
    public Object marshall(SerializerState state, Object o) throws SerializationException {
        if (o instanceof Character) {
            return o.toString();
        }
        if (o instanceof byte[]) {
            return new String((byte[])o);
        }
        if (o instanceof char[]) {
            return String.valueOf((char[])o);
        }
        return o;
    }
}

