/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.tag.core;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.tagext.DynamicAttributes;
import javax.servlet.jsp.tagext.FunctionInfo;
import javax.servlet.jsp.tagext.JspFragment;
import javax.servlet.jsp.tagext.JspTag;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagVariableInfo;
import org.unidal.webres.tag.meta.FunctionMeta;
import org.unidal.webres.tag.meta.TagAttributeMeta;
import org.unidal.webres.tag.meta.TagElementMeta;
import org.unidal.webres.tag.meta.TagMeta;

public abstract class BaseTagLibDefinition {
    private final String m_info;
    private final String m_jspVersion;
    private final String m_libVersion;
    private final String m_shortName;
    private String m_uri;
    private final Map<String, TagInfo> m_tags = new HashMap<String, TagInfo>(5);
    private final Map<String, FunctionInfo> m_functions = new HashMap<String, FunctionInfo>(5);
    private final Map<String, TagFileInfo> m_tagFiles = new HashMap<String, TagFileInfo>(5);

    public BaseTagLibDefinition(String anUriIn, String aShortName, String aDescription, String aVersion, String aJspVersion) {
        this.m_uri = anUriIn;
        this.m_shortName = aShortName;
        this.m_info = aDescription;
        this.m_libVersion = aVersion;
        this.m_jspVersion = "2.0";
        this.init();
    }

    protected abstract void init();

    protected void addTag(String tagName, String tagClassName, String bodycontent, String infoString) {
        this.addTag(tagName, tagClassName, bodycontent, infoString, null, null, null, null, null, null, false);
    }

    protected void addTag(String tagName, String tagClassName, String bodycontent, String infoString, TagExtraInfo tagExtraInfo, TagAttributeInfo[] attributeInfo) {
        this.addTag(tagName, tagClassName, bodycontent, infoString, tagExtraInfo, attributeInfo, null, null, null, null, false);
    }

    protected void addTag(String tagName, String tagClassName, String bodycontent, String infoString, TagExtraInfo tagExtraInfo, TagAttributeInfo[] attributeInfo, String displayName, String smallIcon, String largeIcon, TagVariableInfo[] tagVariableInfos, boolean dynamicAttributes) {
        if (this.m_tags.containsKey(tagName)) {
            throw new RuntimeException("Already registered Tag: " + tagName);
        }
        if (attributeInfo == null) {
            attributeInfo = new TagAttributeInfo[]{};
        }
        if (tagVariableInfos == null) {
            tagVariableInfos = new TagVariableInfo[]{};
        }
        this.m_tags.put(tagName, new TagInfo(tagName, tagClassName, bodycontent, infoString, null, tagExtraInfo, attributeInfo, displayName, smallIcon, largeIcon, tagVariableInfos, dynamicAttributes));
    }

    protected TagInfo getTagNamed(String aTagName) {
        TagInfo result = null;
        for (TagInfo element : this.m_tags.values()) {
            if (!element.getTagName().equals(aTagName)) continue;
            result = element;
            break;
        }
        return result;
    }

    protected void addFunction(Method function) {
        this.addFunction(function, false);
    }

    protected void addFunctionsFromClass(Class<?> ... clazz) {
        Class<?>[] classArray = clazz;
        int n = clazz.length;
        int n2 = 0;
        while (n2 < n) {
            Method[] methods;
            Class<?> c = classArray[n2];
            Method[] methodArray = methods = c.getMethods();
            int n3 = methods.length;
            int n4 = 0;
            while (n4 < n3) {
                Method function = methodArray[n4];
                this.addFunction(function, true);
                ++n4;
            }
            ++n2;
        }
    }

    private void addFunction(Method function, boolean ignoreException) {
        FunctionMeta meta = function.getAnnotation(FunctionMeta.class);
        if (meta != null && meta.excluded()) {
            return;
        }
        int modifier = function.getModifiers();
        if (!Modifier.isPublic(modifier) || !Modifier.isStatic(modifier)) {
            if (!ignoreException) {
                throw new RuntimeException("Only public static method can be JSP function.");
            }
            return;
        }
        String name = meta != null && meta.name().length() > 0 ? meta.name() : function.getName();
        String description = meta != null ? meta.description() : null;
        String className = function.getDeclaringClass().getName();
        StringBuilder sb = new StringBuilder(256);
        boolean first = true;
        sb.append(BaseTagLibDefinition.toJavaSourceType(function.getReturnType().getName())).append(' ');
        sb.append(function.getName()).append('(');
        Class<?>[] classArray = function.getParameterTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> parameterType = classArray[n2];
            if (!first) {
                sb.append(',');
            } else {
                first = false;
            }
            sb.append(BaseTagLibDefinition.toJavaSourceType(parameterType.getName()));
            ++n2;
        }
        sb.append(')');
        this.addFunction(name, function.getName(), className, sb.toString(), description);
    }

    protected void addFunction(String aName, String aClassName, String aSignature) {
        this.addFunction(aName, aName, aClassName, aSignature);
    }

    protected void addFunction(String alias, String aName, String aClassName, String aSignature) {
        this.addFunction(alias, aName, aClassName, aSignature, "");
    }

    protected void addFunction(String alias, String aName, String aClassName, String aSignature, String description) {
        if (this.m_functions.containsKey(alias)) {
            throw new RuntimeException("Already registered Function: " + alias);
        }
        this.m_functions.put(alias, new EsfFunctionInfo(aName, aClassName, aSignature, description));
    }

    protected FunctionInfo getFunctionNamed(String aFunctionName) {
        FunctionInfo result = null;
        for (FunctionInfo element : this.m_functions.values()) {
            if (!element.getName().equals(aFunctionName)) continue;
            result = element;
            break;
        }
        return result;
    }

    protected void addTagFile(String name, String path) {
        if (this.m_tagFiles.containsKey(name)) {
            throw new RuntimeException("Already registered Tag file: " + name);
        }
        String uri = path.replace('\\', '/');
        TagFileInfo tfi = new TagFileInfo(name, uri, null);
        this.m_tagFiles.put(name, tfi);
    }

    protected void addTag(Class<? extends JspTag> clz) {
        this.addTag(clz, null);
    }

    protected void addTag(Class<? extends JspTag> clz, String aTagName) {
        TagMeta tagMeta = clz.getAnnotation(TagMeta.class);
        if (tagMeta == null) {
            BaseTagLibDefinition.chuck(String.valueOf(clz.getName()) + " is missing tag meta annotation.");
        }
        if (aTagName == null) {
            aTagName = tagMeta != null && tagMeta.name().length() > 0 ? tagMeta.name() : clz.getSimpleName();
        }
        ArrayList<EsfTagAttributeInfo> attrInfoList = new ArrayList<EsfTagAttributeInfo>(2);
        Method[] methodArray = clz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            TagElementMeta elementMeta = m.getAnnotation(TagElementMeta.class);
            if (!m.getName().equals("setDynamicElements") && elementMeta != null && !tagMeta.parseBody()) {
                throw new RuntimeException(String.format("%s can not be used when \"parseBody\" is disabled on %s.", TagElementMeta.class.getName(), clz.getName()));
            }
            TagAttributeMeta attrMeta = m.getAnnotation(TagAttributeMeta.class);
            if (attrMeta != null) {
                String name;
                String methodName = m.getName();
                String type = null;
                if (methodName.startsWith("set")) {
                    Class<?>[] paramTypes = m.getParameterTypes();
                    if (paramTypes == null || paramTypes.length != 1) {
                        BaseTagLibDefinition.chuck(String.valueOf(clz.getName()) + "." + methodName + " is not a simple setter.");
                    }
                    type = paramTypes[0].getName();
                } else {
                    BaseTagLibDefinition.chuck(String.valueOf(clz.getName()) + "." + methodName + " is not a property accessor");
                }
                String string = name = attrMeta != null && attrMeta.name().length() > 0 ? attrMeta.name() : BaseTagLibDefinition.getPropertyName(methodName);
                if (attrMeta.fragment()) {
                    if (!JspFragment.class.getName().equals(type)) {
                        throw new RuntimeException(String.format("Parameter type of %s() of %s must be %s.", methodName, clz.getName(), JspFragment.class.getName()));
                    }
                    if (elementMeta != null) {
                        throw new RuntimeException(String.format("%s can not be used with %s(fragment = true) on %s() of %s", TagElementMeta.class.getSimpleName(), TagAttributeMeta.class.getSimpleName(), methodName, clz.getName()));
                    }
                }
                attrInfoList.add(new EsfTagAttributeInfo(name, attrMeta.required(), type, attrMeta.rtexprvalue(), attrMeta.fragment(), attrMeta.description()));
            }
            ++n2;
        }
        TagAttributeInfo[] attrInfoArray = new EsfTagAttributeInfo[attrInfoList.size()];
        attrInfoList.toArray(attrInfoArray);
        Class<? extends TagExtraInfo> extraClz = tagMeta.tagextrainfo();
        TagExtraInfo extraInfo = null;
        if (extraClz != TagExtraInfo.class) {
            try {
                extraInfo = extraClz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (tagMeta.dynamicAttributes() && !DynamicAttributes.class.isAssignableFrom(clz)) {
            throw new RuntimeException(clz + " must implement DynamicAttributes" + " if TagMeta.dynamicAttributes() is true");
        }
        this.addTag(aTagName, clz.getName(), tagMeta.bodycontent(), tagMeta.info(), extraInfo, attrInfoArray, null, null, null, null, tagMeta.dynamicAttributes());
    }

    private static String getPropertyName(String methodName) {
        return Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
    }

    private static void chuck(String message) {
        throw new RuntimeException(message);
    }

    public String getInfo() {
        return this.m_info;
    }

    public String getShortName() {
        return this.m_shortName;
    }

    public String getJspVersion() {
        return this.m_jspVersion;
    }

    public String getLibVersion() {
        return this.m_libVersion;
    }

    public String getUri() {
        return this.m_uri;
    }

    public void setUri(String uri) {
        this.m_uri = uri;
    }

    public Map<String, FunctionInfo> getFunctions() {
        return this.m_functions;
    }

    public Map<String, TagFileInfo> getTagFiles() {
        return this.m_tagFiles;
    }

    public Map<String, TagInfo> getTags() {
        return this.m_tags;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("taglib[");
        sb.append("info: ").append(this.m_info).append(", ");
        sb.append("jspVersion: ").append(this.m_jspVersion).append(", ");
        sb.append("libVersion: ").append(this.m_libVersion).append(", ");
        sb.append("shortName: ").append(this.m_shortName).append(", ");
        sb.append("uri: ").append(this.m_uri).append(", ");
        sb.append("tags: ").append(this.m_tags).append(", ");
        sb.append("functions: ").append(this.m_functions).append(", ");
        sb.append("tag files: ").append(this.m_tagFiles).append("]");
        return sb.toString();
    }

    public static String toJavaSourceType(String type) {
        if (type.charAt(0) != '[') {
            return type;
        }
        int dims = 1;
        String t = null;
        int i = 1;
        while (i < type.length()) {
            if (type.charAt(i) == '[') {
                ++dims;
            } else {
                switch (type.charAt(i)) {
                    case 'Z': {
                        t = "boolean";
                        break;
                    }
                    case 'B': {
                        t = "byte";
                        break;
                    }
                    case 'C': {
                        t = "char";
                        break;
                    }
                    case 'D': {
                        t = "double";
                        break;
                    }
                    case 'F': {
                        t = "float";
                        break;
                    }
                    case 'I': {
                        t = "int";
                        break;
                    }
                    case 'J': {
                        t = "long";
                        break;
                    }
                    case 'S': {
                        t = "short";
                        break;
                    }
                    case 'L': {
                        t = type.substring(i + 1, type.indexOf(59));
                    }
                }
                break;
            }
            ++i;
        }
        StringBuffer resultType = t != null ? new StringBuffer(t) : new StringBuffer();
        while (dims > 0) {
            resultType.append("[]");
            --dims;
        }
        return resultType.toString();
    }

    public static class EsfFunctionInfo
    extends FunctionInfo {
        private String m_description;

        public EsfFunctionInfo(String name, String klass, String signature, String description) {
            super(name, klass, signature);
            this.m_description = description;
        }

        public String getDescription() {
            return this.m_description;
        }

        public void setDescription(String description) {
            this.m_description = description;
        }
    }

    public static class EsfTagAttributeInfo
    extends TagAttributeInfo {
        private String m_description;

        public EsfTagAttributeInfo(String name, boolean required, String type, boolean reqTime, boolean fragment, String description) {
            super(name, required, type, reqTime, fragment);
            this.m_description = description;
        }

        public EsfTagAttributeInfo(String name, boolean required, String type, boolean reqTime, boolean fragment) {
            super(name, required, type, reqTime, fragment);
        }

        public EsfTagAttributeInfo(String name, boolean required, String type, boolean reqTime) {
            super(name, required, type, reqTime);
        }

        public EsfTagAttributeInfo(String name, boolean required, String type, boolean reqTime, String description) {
            super(name, required, type, reqTime);
            this.m_description = description;
        }

        public void setDescription(String description) {
            this.m_description = description;
        }

        public String getDescription() {
            return this.m_description;
        }
    }
}

