/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.tag.core;

import java.lang.reflect.Array;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unidal.webres.converter.ConverterContext;
import org.unidal.webres.converter.ConverterException;
import org.unidal.webres.converter.ConverterManager;
import org.unidal.webres.converter.ConverterRuntime;
import org.unidal.webres.converter.ConverterUtil;
import org.unidal.webres.dom.INode;
import org.unidal.webres.dom.ITagNode;
import org.unidal.webres.dom.NodeType;
import org.unidal.webres.tag.meta.TagElementMeta;
import org.w3c.dom.Node;

public class TagModelInjector {
    private static final TagModelInjector s_instance = new TagModelInjector();
    private static final Map<Object, Map<String, Method>> s_tagElementMap = new HashMap<Object, Map<String, Method>>();

    public static final TagModelInjector getInstance() {
        return s_instance;
    }

    private TagModelInjector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Method> getTagElementMap(Class<? extends Object> clazz) {
        Method[] methods;
        Map<String, Method> map = null;
        Map<Object, Map<String, Method>> map2 = s_tagElementMap;
        synchronized (map2) {
            map = s_tagElementMap.get(clazz);
        }
        if (map != null) {
            return map;
        }
        map = new HashMap<String, Method>();
        Method[] methodArray = methods = clazz.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            TagElementMeta elementMeta = method.getAnnotation(TagElementMeta.class);
            if (elementMeta != null && method.getName().startsWith("set")) {
                map.put(method.getName(), method);
            }
            ++n2;
        }
        Map<Object, Map<String, Method>> map3 = s_tagElementMap;
        synchronized (map3) {
            s_tagElementMap.put(clazz, map);
        }
        return map;
    }

    public void inject(Object tagHandler, ITagNode dom) {
        this.inject(tagHandler, dom, false, null, ConverterRuntime.INSTANCE.getManager());
    }

    public void inject(Object tagHandler, ITagNode dom, boolean override, Object refValue, ConverterManager manager) {
        if (dom == null) {
            return;
        }
        Class<?> clazz = tagHandler.getClass();
        Map<String, Method> map = this.getTagElementMap(clazz);
        for (INode node : dom.getChildNodes()) {
            Object value;
            Method method;
            block18: {
                if (node.getNodeType() != NodeType.TAG) continue;
                String methodName = ConverterUtil.getSetMethodName(((ITagNode)node).getNodeName());
                method = map.get(methodName);
                if (method == null) {
                    throw new IllegalArgumentException("No setter method(" + methodName + ") with annotation EsfTagElementMeta defined in " + clazz);
                }
                if (method.getGenericParameterTypes().length != 1) {
                    throw new IllegalArgumentException("Invalid setter method(" + methodName + ") defined in " + clazz + ", only one parameter allowed");
                }
                TagElementMeta elementMeta = method.getAnnotation(TagElementMeta.class);
                try {
                    try {
                        if (override) {
                            ConverterContext.setThreadLocal("override", true);
                        }
                        value = manager.convert(node, method.getGenericParameterTypes()[0], elementMeta.customized());
                        if (override && refValue != null && value != null) {
                            NodeMerger.INSTANCE.merge(refValue, value, (ITagNode)node);
                            value = refValue;
                        }
                    }
                    catch (ConverterException e) {
                        Object text = manager.convert(node, (Type)((Object)String.class));
                        try {
                            value = manager.convert(text, method.getGenericParameterTypes()[0], elementMeta.customized());
                        }
                        catch (ConverterException ce) {
                            throw e;
                        }
                        if (override) {
                            ConverterContext.setThreadLocal("override", false);
                        }
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    if (override) {
                        ConverterContext.setThreadLocal("override", false);
                    }
                    throw throwable;
                }
                if (override) {
                    ConverterContext.setThreadLocal("override", false);
                }
            }
            try {
                method.invoke(tagHandler, value);
            }
            catch (Exception e) {
                throw new RuntimeException("Error when injecting method: " + method + ", data: " + value, e);
            }
        }
    }

    public void injectAttributes(Node component, Map<String, Object> attributes, IProvider<Method> provider, ConverterManager manager) {
        Class<?> clazz = component.getClass();
        for (Map.Entry<String, Object> a : attributes.entrySet()) {
            String name = a.getKey();
            Method method = provider.getAttribute(component, name);
            if (method == null) {
                String methodName = ConverterUtil.getSetMethodName(name);
                throw new IllegalArgumentException("No setter method(" + methodName + ") defined in " + clazz + " or its super class.");
            }
            Object value = manager.convert(a.getValue(), method.getGenericParameterTypes()[0]);
            try {
                method.invoke((Object)component, value);
            }
            catch (Exception e) {
                throw new RuntimeException("Error when injecting method: " + method + ", data: " + value + ", class: " + clazz);
            }
        }
    }

    public void injectElements(Node component, ITagNode elements, IProvider<Method> provider, ConverterManager manager) {
        Class<?> clazz = component.getClass();
        List<INode> children = elements.getChildNodes();
        for (INode child : children) {
            if (child.getNodeType() != NodeType.TAG) continue;
            Method method = provider.getElement(component, (ITagNode)child);
            if (method == null) {
                String methodName = ConverterUtil.getSetMethodName(((ITagNode)child).getNodeName());
                throw new IllegalArgumentException("No component setter method(" + methodName + ") defined in " + clazz + " or its super class.");
            }
            Object value = manager.convert(child, method.getGenericParameterTypes()[0]);
            try {
                method.invoke((Object)component, value);
            }
            catch (Exception e) {
                throw new RuntimeException("Error when injecting component method: " + method + ", data: " + value + ", class: " + clazz);
            }
        }
    }

    public static interface IProvider<T extends Member> {
        public T getAttribute(Node var1, String var2);

        public T getElement(Node var1, ITagNode var2);
    }

    public static class MethodProvider
    implements IProvider<Method> {
        @Override
        public Method getAttribute(Node current, String name) {
            Class<?> clazz = current.getClass();
            String methodName = ConverterUtil.getSetMethodName(name);
            Method method = ConverterUtil.getSetMethod(clazz, methodName, null);
            return method;
        }

        @Override
        public Method getElement(Node parent, ITagNode child) {
            Class<?> clazz = parent.getClass();
            String methodName = ConverterUtil.getSetMethodName(child.getNodeName());
            Method method = ConverterUtil.getSetMethod(clazz, methodName);
            return method;
        }
    }

    static enum NodeMerger {
        INSTANCE;


        private Object getChildValue(Object source, String attrName) {
            Class<?> clazz = source.getClass();
            Method getMethod = ConverterUtil.getGetMethod(clazz, ConverterUtil.getGetMethodName(attrName));
            try {
                return getMethod.invoke(source, null);
            }
            catch (Exception e1) {
                throw new RuntimeException("Error when invoking method: " + getMethod + ", class: " + clazz);
            }
        }

        private boolean hasELAttribute(ITagNode childNode) {
            for (Map.Entry<String, String> a : childNode.getAttributes().entrySet()) {
                String attrValue;
                String attrName = a.getKey();
                if (!this.isELAttribute(attrName, attrValue = a.getValue())) continue;
                return true;
            }
            return false;
        }

        private boolean isELAttribute(String attrName, String attrValue) {
            if (attrName == null || attrValue == null) {
                return false;
            }
            return attrName.equals("value") && attrValue.startsWith("${") && attrValue.endsWith("}");
        }

        private boolean isLeafNode(INode node) {
            if (node.getNodeType() == NodeType.TAG) {
                ITagNode tNode = (ITagNode)node;
                if (!tNode.hasChildNodes() && tNode.getAttributes().size() == 0) {
                    return true;
                }
                return tNode.getChildNodes().size() == 1 && tNode.getChildNodes().get(0).getNodeType() == NodeType.TEXT;
            }
            throw new RuntimeException("Unexpected node type: " + (Object)((Object)node.getNodeType()));
        }

        public void merge(Object target, Object source, ITagNode node) {
            if (source instanceof Collection) {
                return;
            }
            this.mergeAttributes(target, source, node);
            for (INode child : node.getChildNodes()) {
                ITagNode childNode = (ITagNode)child;
                String childNodeName = childNode.getNodeName();
                Object childValue = this.getChildValue(source, childNodeName);
                if (this.hasELAttribute(childNode)) {
                    this.setChildValue(target, childNode.getNodeName(), childValue);
                    continue;
                }
                Class<?> rawType = childValue.getClass();
                if (Collection.class.isAssignableFrom(rawType) || Map.class.isAssignableFrom(rawType) || Array.class.isAssignableFrom(rawType)) {
                    this.setChildValue(target, childNodeName, childValue);
                    continue;
                }
                if (this.isLeafNode(childNode)) {
                    this.setChildValue(target, childNodeName, childValue);
                    continue;
                }
                this.merge(this.getChildValue(target, childNodeName), childValue, childNode);
            }
        }

        private void mergeAttributes(Object target, Object source, ITagNode childNode) {
            for (Map.Entry<String, String> a : childNode.getAttributes().entrySet()) {
                String attrValue;
                String attrName = a.getKey();
                if (this.isELAttribute(attrName, attrValue = a.getValue())) continue;
                Object childValue = this.getChildValue(source, attrName);
                this.setChildValue(target, attrName, childValue);
            }
        }

        private boolean setChildValue(Object target, String fieldName, Object childValue) {
            Class<?> clazz = target.getClass();
            Method setMethod = ConverterUtil.getSetMethod(clazz, ConverterUtil.getSetMethodName(fieldName));
            try {
                setMethod.invoke(target, childValue);
            }
            catch (Exception e) {
                throw new RuntimeException("Error when setting method: " + setMethod + ", data: " + childValue + ", class: " + clazz);
            }
            return true;
        }
    }
}

