/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.unidal.webres.resource.SystemResourceType;
import org.unidal.webres.resource.api.IResourceType;
import org.unidal.webres.resource.runtime.ResourceRuntimeContext;
import org.unidal.webres.resource.spi.IResourceContainer;
import org.unidal.webres.resource.spi.IResourceContext;
import org.unidal.webres.tag.resource.IResourceMarkerProcessor;

public class SimpleResourceFilter
implements Filter {
    public static final String CSS_TOKEN = "css.token";
    public static final String JS_TOKEN = "js.token";
    public static final String GUID = "guid";

    public void destroy() {
    }

    protected void doFilter(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        try {
            ResourceRuntimeContext.setup((String)req.getContextPath());
            ResourceRuntimeContext ctx = ResourceRuntimeContext.ctx();
            IResourceMarkerProcessor processor = (IResourceMarkerProcessor)ctx.getContainer().getAttribute(IResourceMarkerProcessor.class);
            ResponseWrapper wrapper = new ResponseWrapper(res, processor);
            this.prepare(req, ctx);
            chain.doFilter((ServletRequest)req, (ServletResponse)wrapper);
            wrapper.flushBuffer();
        }
        finally {
            ResourceRuntimeContext.reset();
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (req instanceof HttpServletRequest && res instanceof HttpServletResponse) {
            this.doFilter((HttpServletRequest)req, (HttpServletResponse)res, chain);
        } else {
            chain.doFilter(req, res);
        }
    }

    public void init(FilterConfig config) throws ServletException {
    }

    protected void prepare(HttpServletRequest req, ResourceRuntimeContext ctx) {
        String guid;
        String jsAjaxToken = req.getParameter(JS_TOKEN);
        String cssAjaxToken = req.getParameter(CSS_TOKEN);
        if (jsAjaxToken != null) {
            ctx.setAjaxDedupToken((IResourceType)SystemResourceType.Js, jsAjaxToken);
        }
        if (cssAjaxToken != null) {
            ctx.setAjaxDedupToken((IResourceType)SystemResourceType.Css, cssAjaxToken);
        }
        if (ctx.getDeferRendering() == null) {
            ctx.setDeferRendering(Boolean.valueOf(true));
        }
        if ((guid = req.getParameter(GUID)) != null) {
            IResourceContainer container = ctx.getConfig().getContainer();
            IResourceContext resourceCtx = (IResourceContext)container.removeAttribute(IResourceContext.class, guid);
            Map attributes = (Map)container.removeAttribute(Map.class, guid);
            if (resourceCtx != null) {
                ctx.getResourceContext().setSecure(resourceCtx.isSecure());
                ctx.getResourceContext().setPermutation(resourceCtx.getPermutation());
            }
            if (attributes != null) {
                for (Map.Entry e : attributes.entrySet()) {
                    req.setAttribute((String)e.getKey(), e.getValue());
                }
            }
        }
    }

    static class OutputBuffer
    extends ByteArrayOutputStream {
        private ResponseWrapper m_res;
        private boolean m_chunkEnabled = false;

        public OutputBuffer(ResponseWrapper res, int size) {
            super(size);
            this.m_res = res;
        }

        @Override
        public void close() throws IOException {
            this.finish();
        }

        protected void disableChunk() {
            this.m_chunkEnabled = false;
        }

        protected void finish() throws IOException {
            this.flushChunk(true);
        }

        @Override
        public void flush() throws IOException {
            this.flushChunk(false);
        }

        protected void flushChunk(boolean lastChunk) throws IOException {
            block2: {
                ServletOutputStream out = this.m_res.getResponse().getOutputStream();
                byte[] data = this.getProcessedData();
                this.m_res.setContentLength(data.length);
                out.write(data);
                try {
                    out.flush();
                }
                catch (IOException e) {
                    if (e.getClass().getName().equals("org.mortbay.jetty.EofException") || e.getClass().getName().equals("java.net.SocketException")) break block2;
                    throw e;
                }
            }
        }

        protected byte[] getProcessedData() throws IOException {
            String charset = this.m_res.getCharacterEncoding();
            String content = super.toString(charset);
            StringBuilder processContent = new StringBuilder(content);
            super.reset();
            this.m_res.getProcessor().process(processContent);
            return processContent.toString().getBytes(charset);
        }
    }

    public static class ResponseWrapper
    extends HttpServletResponseWrapper {
        private int m_capacity = 8192;
        private OutputBuffer m_buffer;
        private PrintWriter m_writer;
        private ServletOutputStream m_out;
        private IResourceMarkerProcessor m_processor;

        public ResponseWrapper(HttpServletResponse res, IResourceMarkerProcessor processor) {
            super(res);
            this.m_processor = processor;
        }

        public void flushBuffer() throws IOException {
            super.flushBuffer();
            if (this.m_writer != null) {
                this.m_writer.flush();
            } else if (this.m_out != null) {
                this.m_out.flush();
            }
            if (this.m_buffer != null) {
                this.m_buffer.flush();
            }
        }

        OutputBuffer getBuffer() {
            return this.m_buffer;
        }

        public int getBufferSize() {
            return this.m_capacity;
        }

        public String getCharacterEncoding() {
            String charset = super.getCharacterEncoding();
            return charset == null ? "utf-8" : charset;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.m_writer != null) {
                throw new IOException("Can't getOutputStream() after getWriter()!");
            }
            if (this.m_out == null) {
                this.m_buffer = new OutputBuffer(this, this.m_capacity);
                this.m_out = new ServletOutputStreamWrapper(this.m_buffer);
            }
            return this.m_out;
        }

        protected IResourceMarkerProcessor getProcessor() {
            return this.m_processor;
        }

        public PrintWriter getWriter() throws IOException {
            if (this.m_out != null) {
                throw new IOException("Can't getWriter() after getOutputStream()!");
            }
            if (this.m_writer == null) {
                this.m_buffer = new OutputBuffer(this, this.m_capacity);
                this.m_writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.m_buffer, this.getCharacterEncoding()));
            }
            return this.m_writer;
        }

        public void reset() {
            super.reset();
            if (this.m_buffer != null) {
                this.m_buffer.reset();
            }
        }

        public void resetBuffer() {
            super.resetBuffer();
            if (this.m_buffer != null) {
                this.m_buffer.reset();
            }
        }

        public void setBufferSize(int size) {
            if (size > this.m_capacity) {
                this.m_capacity = size;
            }
        }

        public void setContentLength(int len) {
            if (this.m_buffer != null) {
                this.m_buffer.disableChunk();
            }
            if (len > this.m_capacity) {
                this.m_capacity = len;
            }
        }

        public void setHeader(String name, String value) {
            if (this.m_buffer != null && "Connection".equalsIgnoreCase(name) && "close".equalsIgnoreCase(value)) {
                this.m_buffer.disableChunk();
            }
            super.setHeader(name, value);
        }

        public String toString() {
            if (this.m_buffer != null) {
                try {
                    return this.m_buffer.toString(this.getCharacterEncoding());
                }
                catch (UnsupportedEncodingException e) {
                    return this.m_buffer.toString();
                }
            }
            return "";
        }
    }

    static class ServletOutputStreamWrapper
    extends ServletOutputStream {
        private OutputBuffer m_buffer;

        public ServletOutputStreamWrapper(OutputBuffer buffer) {
            this.m_buffer = buffer;
        }

        public void close() throws IOException {
            this.m_buffer.finish();
        }

        public void flush() throws IOException {
            this.m_buffer.flush();
        }

        public void write(int b) throws IOException {
            this.m_buffer.write(b);
        }
    }
}

