/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.server;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.unidal.webres.helper.Files;
import org.unidal.webres.helper.Splitters;
import org.unidal.webres.resource.ResourceFactory;
import org.unidal.webres.resource.ResourceUrn;
import org.unidal.webres.resource.SystemResourceType;
import org.unidal.webres.resource.api.ICss;
import org.unidal.webres.resource.api.ICssRef;
import org.unidal.webres.resource.api.IImage;
import org.unidal.webres.resource.api.IImageMeta;
import org.unidal.webres.resource.api.IJs;
import org.unidal.webres.resource.api.IJsRef;
import org.unidal.webres.resource.api.IResource;
import org.unidal.webres.resource.api.IResourceRef;
import org.unidal.webres.resource.api.IResourceUrn;
import org.unidal.webres.resource.css.CssFactory;
import org.unidal.webres.resource.js.JsFactory;
import org.unidal.webres.resource.runtime.ResourceInitializer;
import org.unidal.webres.resource.runtime.ResourceRuntime;
import org.unidal.webres.resource.runtime.ResourceRuntimeContext;

public class SimpleResourceServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private File m_warRoot;

    protected <T extends IResourceRef<?>> List<T> buildResourceRefs(String value) {
        List urns = Splitters.by((char)'|').split(value);
        ArrayList<IResourceRef> refs = new ArrayList<IResourceRef>(urns == null ? 0 : urns.size());
        if (urns != null) {
            for (String urn : urns) {
                IResourceUrn u = ResourceUrn.parse((String)urn);
                IResourceRef ref = ResourceFactory.forRef().createRef(u.getResourceTypeName(), u.getNamespace(), u.getPathInfo());
                refs.add(ref);
            }
        }
        return refs;
    }

    protected void handleAggregation(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String pathInfo = req.getPathInfo();
        int pos1 = pathInfo.indexOf(47, 1);
        String type = pos1 > 0 ? pathInfo.substring(1, pos1) : pathInfo.substring(1);
        if ("js".equals(type)) {
            try {
                List refs = this.buildResourceRefs(req.getParameter("urns"));
                IJsRef ref = JsFactory.forRef().createAggregatedRef("/js", refs);
                this.handleResource(req, res, (IResourceRef<?>)ref);
            }
            catch (Exception e) {
                this.handleException(req, res, e);
            }
        } else if ("css".equals(type)) {
            try {
                List refs = this.buildResourceRefs(req.getParameter("urns"));
                ICssRef ref = CssFactory.forRef().createAggregatedRef("/css", refs);
                this.handleResource(req, res, (IResourceRef<?>)ref);
            }
            catch (Exception e) {
                this.handleException(req, res, e);
            }
        } else {
            throw new UnsupportedOperationException(String.format("Unknown type(%s), only 'js', 'css' and 'json' are allowed!", type));
        }
    }

    protected void handleException(HttpServletRequest req, HttpServletResponse res, Exception e) throws IOException {
        String pattern = "Error when handling fragment request(%s)! <br><br>Exception:<pre>%s</pre>";
        PrintWriter pw = new PrintWriter(new StringWriter());
        e.printStackTrace(pw);
        e.printStackTrace();
        this.showPage404(req, res, String.format(pattern, req.getRequestURI(), pw.toString()));
    }

    protected void handleFragment(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String pathInfo = req.getPathInfo();
        int pos1 = pathInfo.indexOf(47, 1);
        int pos2 = pathInfo.indexOf(47, pos1 + 1);
        if (pos1 > 0 && pos2 > pos1) {
            String resourceType = pathInfo.substring(1, pos1);
            String namespace = pathInfo.substring(pos1 + 1, pos2);
            String path = pathInfo.substring(pos2);
            try {
                IResourceRef ref = ResourceFactory.forRef().createRef(resourceType, namespace, path);
                this.handleResource(req, res, ref);
            }
            catch (Exception e) {
                this.handleException(req, res, e);
            }
        }
    }

    protected void handleLocalFile(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String requestUri = req.getRequestURI();
        String contextPath = req.getContextPath();
        File file = contextPath == null ? new File(this.m_warRoot, requestUri) : new File(this.m_warRoot, requestUri.substring(contextPath.length()));
        if (file.isFile()) {
            try {
                String ext;
                byte[] content = Files.forIO().readFrom(file);
                String path = file.getPath();
                int pos = path.lastIndexOf(46);
                String string = ext = pos > 0 ? path.substring(pos + 1) : "";
                if (ext.equals("js")) {
                    this.renderPage(res, 200, "application/x-javascript", content);
                } else if (ext.equals("css")) {
                    this.renderPage(res, 200, "text/css", content);
                } else if (ext.equals("jpg") || ext.equals("jpeg") || ext.equals("png") || ext.equals("gif")) {
                    this.renderPage(res, 200, "images/" + ext, content);
                } else if (ext.equals(".svg")) {
                    this.renderPage(res, 200, "images/svg-xml", content);
                } else {
                    this.renderPage(res, 200, "text/html", content);
                }
            }
            catch (Exception e) {
                this.handleException(req, res, e);
            }
        }
    }

    protected void handleResource(HttpServletRequest req, HttpServletResponse res, IResourceRef<?> ref) throws IOException {
        ResourceRuntimeContext.setup((String)this.getServletContext().getContextPath());
        IResource resource = ref.resolve(ResourceRuntimeContext.ctx().getResourceContext());
        if (ref.getResourceType() == SystemResourceType.Js) {
            IJs js = (IJs)resource;
            this.renderPage(res, 200, "application/x-javascript", (String)js.getContent());
        } else if (ref.getResourceType() == SystemResourceType.Css) {
            ICss css = (ICss)resource;
            this.renderPage(res, 200, "text/css", (String)css.getContent());
        } else if (ref.getResourceType() == SystemResourceType.Image) {
            IImage image = (IImage)resource;
            this.renderPage(res, 200, ((IImageMeta)image.getMeta()).getMimeType(), (byte[])image.getContent());
        } else {
            throw new UnsupportedOperationException(String.format("Resource type(%s) is not supported yet, please contact administrator!", ref.getResourceType().getName()));
        }
    }

    public void init() throws ServletException {
        ServletContext servletContext = this.getServletContext();
        String contextPath = servletContext.getContextPath();
        File warRoot = new File(servletContext.getRealPath("/"));
        if (!ResourceRuntime.INSTANCE.hasConfig(contextPath)) {
            ResourceInitializer.initialize((String)contextPath, (File)warRoot);
        }
        this.m_warRoot = warRoot;
    }

    protected void renderPage(HttpServletResponse res, int status, String contextType, byte[] content) throws IOException {
        res.setStatus(status);
        if (contextType != null) {
            res.setContentType(contextType);
        }
        res.setContentLength(content.length);
        res.getOutputStream().write(content);
        res.flushBuffer();
    }

    protected void renderPage(HttpServletResponse res, int status, String contextType, String content) throws IOException {
        String charset = "utf-8";
        byte[] data = content.getBytes(charset);
        this.renderPage(res, status, String.valueOf(contextType) + "; charset=" + charset, data);
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String servletPath = req.getServletPath();
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            this.showPageWelcome(req, res);
        } else if (servletPath.equals("/f")) {
            this.handleFragment(req, res);
        } else if (servletPath.equals("/z")) {
            this.handleAggregation(req, res);
        } else {
            this.handleLocalFile(req, res);
        }
        if (!res.isCommitted()) {
            this.showPage404(req, res, "Bad request - " + req.getRequestURI());
        }
    }

    protected void showPage404(HttpServletRequest req, HttpServletResponse res, String message) throws IOException {
        this.renderPage(res, 404, "text/html", message);
    }

    protected void showPageWelcome(HttpServletRequest req, HttpServletResponse res) throws IOException {
        ServletContext ctx = this.getServletContext();
        String contextPath = ctx.getContextPath();
        File warRoot = new File(ctx.getRealPath("/"));
        String message = String.format("Welcome to Resource Servlet! <br><br>War Root: %s<br>Context Path: %s", warRoot.getCanonicalPath(), contextPath);
        this.renderPage(res, 200, "text/html", message);
    }
}

