/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.server.css;

import org.unidal.webres.helper.Joiners;
import org.unidal.webres.resource.annotation.ContextPath;
import org.unidal.webres.resource.api.ICssRef;
import org.unidal.webres.resource.api.IResourceUrn;
import org.unidal.webres.resource.css.AggregatedCss;
import org.unidal.webres.resource.spi.IResourceContext;
import org.unidal.webres.resource.spi.IResourceRegisterable;
import org.unidal.webres.resource.spi.IResourceUrlBuilder;

public class SimpleAggregatedCssUrlBuilder
implements IResourceUrlBuilder<AggregatedCss>,
IResourceRegisterable<SimpleAggregatedCssUrlBuilder> {
    private String m_contextPath;
    private String m_servletPath;

    public SimpleAggregatedCssUrlBuilder(String servletPath) {
        this.m_servletPath = servletPath;
        if (servletPath != null && !servletPath.startsWith("/") && servletPath.endsWith("/")) {
            throw new RuntimeException("servletPath should be null or starting with '/' but not ending with '/'.");
        }
    }

    public String build(IResourceContext ctx, AggregatedCss css) {
        StringBuilder sb = new StringBuilder(128);
        if (this.m_contextPath != null) {
            sb.append(this.m_contextPath);
        }
        if (this.m_servletPath != null) {
            sb.append(this.m_servletPath);
        }
        IResourceUrn urn = css.getMeta().getUrn();
        sb.append('/').append(urn.getResourceTypeName());
        sb.append('/').append(urn.getNamespace());
        sb.append(urn.getPathInfo());
        sb.append("?urns=");
        sb.append(Joiners.by((char)'|').join(css.getRef().getRefs(), (Joiners.IBuilder)new Joiners.IBuilder<ICssRef>(){

            public String asString(ICssRef ref) {
                return ref.getUrn().toString();
            }
        }));
        return sb.toString();
    }

    public SimpleAggregatedCssUrlBuilder getRegisterInstance() {
        return this;
    }

    public String getRegisterKey() {
        return "css.aggregated";
    }

    public Class<? super SimpleAggregatedCssUrlBuilder> getRegisterType() {
        return IResourceUrlBuilder.class;
    }

    @ContextPath
    public void setContextPath(String contextPath) {
        this.m_contextPath = contextPath;
    }
}

