/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.server.css;

import org.unidal.webres.resource.annotation.ContextPath;
import org.unidal.webres.resource.api.ICss;
import org.unidal.webres.resource.api.ICssMeta;
import org.unidal.webres.resource.api.IResourceUrn;
import org.unidal.webres.resource.spi.IResourceContext;
import org.unidal.webres.resource.spi.IResourceRegisterable;
import org.unidal.webres.resource.spi.IResourceUrlBuilder;

public class SimpleInlineCssUrlBuilder
implements IResourceUrlBuilder<ICss>,
IResourceRegisterable<SimpleInlineCssUrlBuilder> {
    private String m_contextPath;
    private String m_servletPath;

    public SimpleInlineCssUrlBuilder(String servletPath) {
        this.m_servletPath = servletPath;
        if (servletPath != null && !servletPath.startsWith("/") && servletPath.endsWith("/")) {
            throw new RuntimeException("servletPath should be null or starting with '/' but not ending with '/'.");
        }
    }

    public String build(IResourceContext ctx, ICss css) {
        StringBuilder sb = new StringBuilder(128);
        if (this.m_contextPath != null) {
            sb.append(this.m_contextPath);
        }
        if (this.m_servletPath != null) {
            sb.append(this.m_servletPath);
        }
        IResourceUrn urn = ((ICssMeta)css.getMeta()).getUrn();
        sb.append('/').append(urn.getResourceTypeName());
        sb.append('/').append(urn.getNamespace());
        sb.append(urn.getPathInfo());
        return sb.toString();
    }

    public SimpleInlineCssUrlBuilder getRegisterInstance() {
        return this;
    }

    public String getRegisterKey() {
        return "css.inline";
    }

    public Class<? super SimpleInlineCssUrlBuilder> getRegisterType() {
        return IResourceUrlBuilder.class;
    }

    @ContextPath
    public void setContextPath(String contextPath) {
        this.m_contextPath = contextPath;
    }
}

