/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.server.img;

import org.unidal.webres.resource.annotation.ContextPath;
import org.unidal.webres.resource.api.IImage;
import org.unidal.webres.resource.api.IImageMeta;
import org.unidal.webres.resource.api.IResourceUrn;
import org.unidal.webres.resource.spi.IResourceContext;
import org.unidal.webres.resource.spi.IResourceRegisterable;
import org.unidal.webres.resource.spi.IResourceUrlBuilder;

public class SimpleSharedImageUrlBuilder
implements IResourceUrlBuilder<IImage>,
IResourceRegisterable<SimpleSharedImageUrlBuilder> {
    private String m_contextPath;
    private String m_servletPath;

    public SimpleSharedImageUrlBuilder(String servletPath) {
        this.m_servletPath = servletPath;
        if (servletPath != null && !servletPath.startsWith("/") && servletPath.endsWith("/")) {
            throw new RuntimeException("servletPath should be null or starting with '/' but not ending with '/'.");
        }
    }

    public String build(IResourceContext ctx, IImage image) {
        StringBuilder sb = new StringBuilder(128);
        if (this.m_contextPath != null) {
            sb.append(this.m_contextPath);
        }
        if (this.m_servletPath != null) {
            sb.append(this.m_servletPath);
        }
        IResourceUrn urn = ((IImageMeta)image.getMeta()).getUrn();
        sb.append('/').append(urn.getResourceTypeName());
        sb.append('/').append(urn.getNamespace());
        if (ctx.getPermutation() != null && !ctx.isFallbackPermutation()) {
            sb.append('/').append(ctx.getPermutation().toExternal());
        }
        sb.append(urn.getPathInfo());
        return sb.toString();
    }

    public SimpleSharedImageUrlBuilder getRegisterInstance() {
        return this;
    }

    public String getRegisterKey() {
        return "img.shared";
    }

    public Class<? super SimpleSharedImageUrlBuilder> getRegisterType() {
        return IResourceUrlBuilder.class;
    }

    @ContextPath
    public void setContextPath(String contextPath) {
        this.m_contextPath = contextPath;
    }
}

