/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.server.js;

import org.unidal.webres.resource.annotation.ContextPath;
import org.unidal.webres.resource.api.IJs;
import org.unidal.webres.resource.api.IJsMeta;
import org.unidal.webres.resource.api.IResourceUrn;
import org.unidal.webres.resource.spi.IResourceContext;
import org.unidal.webres.resource.spi.IResourceRegisterable;
import org.unidal.webres.resource.spi.IResourceUrlBuilder;

public class SimpleInlineJsUrlBuilder
implements IResourceUrlBuilder<IJs>,
IResourceRegisterable<SimpleInlineJsUrlBuilder> {
    private String m_contextPath;
    private String m_servletPath;

    public SimpleInlineJsUrlBuilder(String servletPath) {
        this.m_servletPath = servletPath;
        if (servletPath != null && !servletPath.startsWith("/") && servletPath.endsWith("/")) {
            throw new RuntimeException("servletPath should be null or starting with '/' but not ending with '/'.");
        }
    }

    public String build(IResourceContext ctx, IJs js) {
        StringBuilder sb = new StringBuilder(128);
        if (this.m_contextPath != null) {
            sb.append(this.m_contextPath);
        }
        if (this.m_servletPath != null) {
            sb.append(this.m_servletPath);
        }
        IResourceUrn urn = ((IJsMeta)js.getMeta()).getUrn();
        sb.append('/').append(urn.getResourceTypeName());
        sb.append('/').append(urn.getNamespace());
        sb.append(urn.getPathInfo());
        return sb.toString();
    }

    public SimpleInlineJsUrlBuilder getRegisterInstance() {
        return this;
    }

    public String getRegisterKey() {
        return "js.inline";
    }

    public Class<? super SimpleInlineJsUrlBuilder> getRegisterType() {
        return IResourceUrlBuilder.class;
    }

    @ContextPath
    public void setContextPath(String contextPath) {
        this.m_contextPath = contextPath;
    }
}

