/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.server.link;

import java.util.List;
import org.unidal.webres.helper.Splitters;
import org.unidal.webres.resource.ResourceUrn;
import org.unidal.webres.resource.SystemResourceType;
import org.unidal.webres.resource.api.ILink;
import org.unidal.webres.resource.api.ILinkMeta;
import org.unidal.webres.resource.api.ILinkRef;
import org.unidal.webres.resource.api.INamespace;
import org.unidal.webres.resource.api.IResourceType;
import org.unidal.webres.resource.api.IResourceUrn;
import org.unidal.webres.resource.api.ResourceException;
import org.unidal.webres.resource.injection.ResourceAttribute;
import org.unidal.webres.resource.spi.IResourceContext;
import org.unidal.webres.resource.spi.IResourceRegisterable;
import org.unidal.webres.resource.spi.IResourceResolver;
import org.unidal.webres.resource.spi.IResourceUrlBuilder;
import org.unidal.webres.server.SimpleResourceNamespace;
import org.unidal.webres.server.link.CmdLink;

public class CmdLinkResolver
implements IResourceResolver<ILinkRef, ILink>,
IResourceRegisterable<CmdLinkResolver> {
    private IResourceUrlBuilder<ILink> m_urlBuilder;

    protected String buildPathInfo(IResourceContext ctx, String path) {
        List parts = Splitters.by((char)'/').split(path);
        StringBuilder sb = new StringBuilder(path.length() + 16);
        int len = parts.size();
        boolean inQs = false;
        int i = 1;
        while (i < len) {
            String part = (String)parts.get(i);
            if (part.startsWith("&")) {
                if (!inQs) {
                    sb.append('?');
                    inQs = true;
                } else {
                    sb.append('&');
                }
                if (part.indexOf(61) > 0) {
                    sb.append(part.substring(1));
                } else {
                    String value = i + 1 < len ? (String)parts.get(i + 1) : null;
                    sb.append(part.substring(1));
                    sb.append('=');
                    sb.append(value);
                    ++i;
                }
            } else if (part.startsWith("%")) {
                ctx.setVariation(part.substring(1), (Object)true);
            } else if (!inQs) {
                sb.append('/').append(part);
            } else {
                throw new RuntimeException(String.format("%s should be starting with '&'.", part));
            }
            ++i;
        }
        return sb.toString();
    }

    protected CmdLinkMeta getLinkMeta(IResourceContext ctx, IResourceUrn urn) {
        String path = urn.getResourceId();
        String pathInfo = this.buildPathInfo(ctx, path);
        return new CmdLinkMeta(path, pathInfo);
    }

    public INamespace getNamespace() {
        return SimpleResourceNamespace.CMD;
    }

    public CmdLinkResolver getRegisterInstance() {
        return this;
    }

    public String getRegisterKey() {
        return "link.cmd";
    }

    public Class<? super CmdLinkResolver> getRegisterType() {
        return IResourceResolver.class;
    }

    public IResourceType getResourceType() {
        return SystemResourceType.Link;
    }

    public CmdLink resolve(ILinkRef ref, IResourceContext ctx) throws ResourceException {
        IResourceUrn urn = ref.getUrn();
        CmdLinkMeta meta = this.getLinkMeta(ctx, urn);
        CmdLink link = new CmdLink(ctx, meta);
        link.validate();
        link.setUrlBuilder(this.m_urlBuilder);
        return link;
    }

    @ResourceAttribute(value="link.cmd")
    public void setUrlBuilder(IResourceUrlBuilder<? extends ILink> urlBuilder) {
        this.m_urlBuilder = urlBuilder;
    }

    public static class CmdLinkMeta
    implements ILinkMeta {
        private IResourceUrn m_urn;

        public CmdLinkMeta(String path, String pathInfo) {
            this.m_urn = new ResourceUrn(SystemResourceType.Link.getName(), SimpleResourceNamespace.CMD.getName(), path);
            this.m_urn.setPathInfo(pathInfo);
        }

        public IResourceType getResourceType() {
            return SystemResourceType.Link;
        }

        public IResourceUrn getUrn() {
            return this.m_urn;
        }

        public String toString() {
            return String.format("CmdLinkMeta[path=%s]", this.m_urn.getPathInfo());
        }
    }
}

