/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.webres.server.template;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.unidal.webres.helper.Files;
import org.unidal.webres.resource.annotation.ContextPath;
import org.unidal.webres.resource.annotation.ServerUrlPrefix;
import org.unidal.webres.resource.annotation.WarRoot;
import org.unidal.webres.resource.api.ITemplate;
import org.unidal.webres.resource.api.ITemplateContext;
import org.unidal.webres.resource.api.ITemplateMeta;
import org.unidal.webres.resource.runtime.ResourceRuntimeContext;
import org.unidal.webres.resource.spi.IResourceContainer;
import org.unidal.webres.resource.spi.IResourceContext;
import org.unidal.webres.resource.spi.IResourceRegisterable;
import org.unidal.webres.resource.spi.ITemplateEvaluator;
import org.unidal.webres.resource.template.TemplateLanguage;

public class JspTemplateEvaluator
implements ITemplateEvaluator,
IResourceRegisterable<JspTemplateEvaluator> {
    private File m_warRoot;
    private String m_serverUrlPrefix;
    private String m_contextPath;
    private ITemplateContext m_ctx;

    protected String buildGuid(IResourceContext resourceCtx, ITemplateContext templateCtx) {
        Map attributes;
        IResourceContainer container = ResourceRuntimeContext.ctx().getConfig().getContainer();
        int hash1 = System.identityHashCode(resourceCtx);
        int hash2 = System.identityHashCode(templateCtx);
        String guid = String.valueOf(hash1 ^ hash2);
        container.setAttribute(IResourceContext.class, guid, (Object)resourceCtx);
        if (this.m_ctx != null && !(attributes = this.m_ctx.getAttributes()).isEmpty()) {
            container.setAttribute(Map.class, guid, (Object)attributes);
        }
        return guid;
    }

    protected String buildRequestUrl(String path, String guid) {
        StringBuilder sb = new StringBuilder(256);
        sb.append(this.m_serverUrlPrefix);
        if (this.m_contextPath != null) {
            sb.append(this.m_contextPath);
        }
        sb.append(path);
        sb.append('?').append("guid").append('=').append(guid);
        return sb.toString();
    }

    public String evaluate(IResourceContext ctx, ITemplate template) throws Exception {
        if (this.m_serverUrlPrefix == null) {
            throw new IllegalStateException("No servlet url prefix found, please register it use @ServerUrlPrefix!");
        }
        String path = this.saveToJspFile(template);
        URL url = new URL(this.buildRequestUrl(path, this.buildGuid(ctx, this.m_ctx)));
        String result = Files.forIO().readFrom(url.openStream(), "utf-8");
        return result;
    }

    public JspTemplateEvaluator getRegisterInstance() {
        return this;
    }

    public String getRegisterKey() {
        return TemplateLanguage.Jsp.name();
    }

    public Class<? super JspTemplateEvaluator> getRegisterType() {
        return ITemplateEvaluator.class;
    }

    protected String saveToJspFile(ITemplate template) throws IOException {
        String path = ((ITemplateMeta)template.getMeta()).getUrn().getPathInfo();
        if (!path.endsWith(".jsp") && !path.endsWith(".jspf")) {
            path = String.valueOf(path) + ".jsp";
        }
        File file = new File(this.m_warRoot, path);
        Files.forIO().writeTo(file, (String)template.getContent());
        return path;
    }

    public void setContext(ITemplateContext ctx) {
        this.m_ctx = ctx;
    }

    @ContextPath
    public void setContextPath(String contextPath) {
        this.m_contextPath = contextPath;
    }

    @ServerUrlPrefix
    public void setServerUrlPrefix(String serverUrlPrefix) {
        this.m_serverUrlPrefix = serverUrlPrefix;
    }

    @WarRoot
    public void setWarRoot(File warRoot) {
        this.m_warRoot = warRoot;
    }

    public static class MockOutputStream
    extends ServletOutputStream {
        private ByteArrayOutputStream m_baos;

        public MockOutputStream(ByteArrayOutputStream baos) {
            this.m_baos = baos;
        }

        public void write(byte[] bytes, int off, int len) throws IOException {
            this.m_baos.write(bytes, off, len);
        }

        public void write(int b) throws IOException {
            this.m_baos.write(b);
        }
    }

    public static class MockRequest
    implements HttpServletRequest {
        private Map<String, Object> m_attributes = new HashMap<String, Object>();
        private ServletContext m_ctx;

        public MockRequest(ServletContext ctx) {
            this.m_ctx = ctx;
        }

        public Object getAttribute(String name) {
            return this.m_attributes.get(name);
        }

        public Enumeration<String> getAttributeNames() {
            return Collections.enumeration(this.m_attributes.keySet());
        }

        public String getAuthType() {
            return null;
        }

        public String getCharacterEncoding() {
            return "utf-8";
        }

        public int getContentLength() {
            return 0;
        }

        public String getContentType() {
            return null;
        }

        public String getContextPath() {
            return this.m_ctx.getContextPath();
        }

        public Cookie[] getCookies() {
            return null;
        }

        public long getDateHeader(String arg0) {
            return 0L;
        }

        public String getHeader(String arg0) {
            return null;
        }

        public Enumeration<String> getHeaderNames() {
            return null;
        }

        public Enumeration<String> getHeaders(String arg0) {
            return null;
        }

        public ServletInputStream getInputStream() throws IOException {
            return null;
        }

        public int getIntHeader(String arg0) {
            return 0;
        }

        public String getLocalAddr() {
            return null;
        }

        public Locale getLocale() {
            return null;
        }

        public Enumeration<String> getLocales() {
            return null;
        }

        public String getLocalName() {
            return null;
        }

        public int getLocalPort() {
            return 0;
        }

        public String getMethod() {
            return null;
        }

        public String getParameter(String arg0) {
            return null;
        }

        public Map<String, String[]> getParameterMap() {
            return null;
        }

        public Enumeration<String> getParameterNames() {
            return null;
        }

        public String[] getParameterValues(String arg0) {
            return null;
        }

        public String getPathInfo() {
            return null;
        }

        public String getPathTranslated() {
            return null;
        }

        public String getProtocol() {
            return null;
        }

        public String getQueryString() {
            return null;
        }

        public BufferedReader getReader() throws IOException {
            return null;
        }

        public String getRealPath(String arg0) {
            return null;
        }

        public String getRemoteAddr() {
            return null;
        }

        public String getRemoteHost() {
            return null;
        }

        public int getRemotePort() {
            return 0;
        }

        public String getRemoteUser() {
            return null;
        }

        public RequestDispatcher getRequestDispatcher(String path) {
            return this.m_ctx.getRequestDispatcher(path);
        }

        public String getRequestedSessionId() {
            return null;
        }

        public String getRequestURI() {
            return null;
        }

        public StringBuffer getRequestURL() {
            return null;
        }

        public String getScheme() {
            return null;
        }

        public String getServerName() {
            return null;
        }

        public int getServerPort() {
            return 0;
        }

        public String getServletPath() {
            return null;
        }

        public HttpSession getSession() {
            return null;
        }

        public HttpSession getSession(boolean arg0) {
            return null;
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public boolean isRequestedSessionIdFromCookie() {
            return false;
        }

        public boolean isRequestedSessionIdFromUrl() {
            return false;
        }

        public boolean isRequestedSessionIdFromURL() {
            return false;
        }

        public boolean isRequestedSessionIdValid() {
            return false;
        }

        public boolean isSecure() {
            return false;
        }

        public boolean isUserInRole(String arg0) {
            return false;
        }

        public void removeAttribute(String name) {
        }

        public void setAttribute(String name, Object value) {
            this.m_attributes.put(name, value);
        }

        public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
        }
    }

    public static class MockResponse
    implements HttpServletResponse {
        public ByteArrayOutputStream m_baos = new ByteArrayOutputStream();
        private ServletOutputStream m_out = new MockOutputStream(this.m_baos);
        private boolean m_committed;
        private String m_charset;
        private String m_contentType;

        public void addCookie(Cookie arg0) {
        }

        public void addDateHeader(String arg0, long arg1) {
        }

        public void addHeader(String arg0, String arg1) {
        }

        public void addIntHeader(String arg0, int arg1) {
        }

        public boolean containsHeader(String arg0) {
            return false;
        }

        public String encodeRedirectUrl(String arg0) {
            return null;
        }

        public String encodeRedirectURL(String arg0) {
            return null;
        }

        public String encodeUrl(String arg0) {
            return null;
        }

        public String encodeURL(String arg0) {
            return null;
        }

        public void flushBuffer() throws IOException {
            this.m_out.flush();
        }

        public int getBufferSize() {
            return 8192;
        }

        public String getCharacterEncoding() {
            return this.m_charset;
        }

        public String getContentType() {
            return this.m_contentType;
        }

        public Locale getLocale() {
            return Locale.US;
        }

        public String getOutput() {
            if (this.m_charset != null) {
                try {
                    return this.m_baos.toString(this.m_charset);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            return this.m_baos.toString();
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return this.m_out;
        }

        public PrintWriter getWriter() throws IOException {
            return new PrintWriter((OutputStream)this.m_out);
        }

        public boolean isCommitted() {
            return this.m_committed;
        }

        public void reset() {
            this.resetBuffer();
        }

        public void resetBuffer() {
            this.m_baos.reset();
        }

        public void sendError(int arg0) throws IOException {
        }

        public void sendError(int arg0, String arg1) throws IOException {
        }

        public void sendRedirect(String arg0) throws IOException {
        }

        public void setBufferSize(int arg0) {
        }

        public void setCharacterEncoding(String charset) {
            this.m_charset = charset;
        }

        public void setCommitted(boolean committed) {
            this.m_committed = committed;
        }

        public void setContentLength(int arg0) {
        }

        public void setContentType(String contentType) {
            int pos = contentType.toLowerCase().indexOf("charset=");
            if (pos > 0) {
                this.m_charset = contentType.substring(pos + "charset=".length()).trim();
            }
            this.m_contentType = contentType;
        }

        public void setDateHeader(String arg0, long arg1) {
        }

        public void setHeader(String arg0, String arg1) {
        }

        public void setIntHeader(String arg0, int arg1) {
        }

        public void setLocale(Locale locale) {
        }

        public void setStatus(int arg0) {
        }

        public void setStatus(int arg0, String arg1) {
        }
    }
}

