/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.apps.fixed_webpush;

import com.google.crypto.tink.HybridEncrypt;
import com.google.crypto.tink.apps.fixed_webpush.WebPushConstants;
import com.google.crypto.tink.apps.fixed_webpush.WebPushUtil;
import com.google.crypto.tink.subtle.EllipticCurves;
import com.google.crypto.tink.subtle.EngineFactory;
import com.google.crypto.tink.subtle.Random;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class WebPushHybridEncrypt
implements HybridEncrypt {
    private final byte[] recipientPublicKey;
    private final byte[] authSecret;
    private final ECPoint recipientPublicPoint;
    private final int recordSize;
    private final int paddingSize;

    private WebPushHybridEncrypt(Builder builder) throws GeneralSecurityException {
        if (builder.recipientPublicKey == null || builder.recipientPublicPoint == null) {
            throw new IllegalArgumentException("must set recipient's public key with Builder.withRecipientPublicKey");
        }
        this.recipientPublicKey = builder.recipientPublicKey;
        this.recipientPublicPoint = builder.recipientPublicPoint;
        if (builder.authSecret == null) {
            throw new IllegalArgumentException("must set auth secret with Builder.withAuthSecret");
        }
        if (builder.authSecret.length != 16) {
            throw new IllegalArgumentException("auth secret must have 16 bytes");
        }
        this.authSecret = builder.authSecret;
        this.recordSize = builder.recordSize;
        this.paddingSize = builder.paddingSize;
    }

    public byte[] encrypt(byte[] plaintext, byte[] contextInfo) throws GeneralSecurityException {
        if (contextInfo != null) {
            throw new GeneralSecurityException("contextInfo must be null because it is unused");
        }
        if (plaintext.length > this.recordSize - this.paddingSize - 16 - 1) {
            throw new GeneralSecurityException(String.format("plaintext too long; with record size = %d and padding size = %d, plaintext cannot be longer than %d", this.recordSize, this.paddingSize, this.recordSize - this.paddingSize - 103));
        }
        KeyPair keyPair = EllipticCurves.generateKeyPair((EllipticCurves.CurveType)WebPushConstants.NIST_P256_CURVE_TYPE);
        ECPrivateKey ephemeralPrivateKey = (ECPrivateKey)keyPair.getPrivate();
        ECPublicKey ephemeralPublicKey = (ECPublicKey)keyPair.getPublic();
        byte[] ecdhSecret = EllipticCurves.computeSharedSecret((ECPrivateKey)ephemeralPrivateKey, (ECPoint)this.recipientPublicPoint);
        byte[] ephemeralPublicKeyBytes = EllipticCurves.pointEncode((EllipticCurves.CurveType)WebPushConstants.NIST_P256_CURVE_TYPE, (EllipticCurves.PointFormatType)WebPushConstants.UNCOMPRESSED_POINT_FORMAT, (ECPoint)ephemeralPublicKey.getW());
        byte[] ikm = WebPushUtil.computeIkm(ecdhSecret, this.authSecret, this.recipientPublicKey, ephemeralPublicKeyBytes);
        byte[] salt = Random.randBytes((int)16);
        byte[] cek = WebPushUtil.computeCek(ikm, salt);
        byte[] nonce = WebPushUtil.computeNonce(ikm, salt);
        return ByteBuffer.allocate(103 + plaintext.length + this.paddingSize).put(salt).putInt(this.recordSize).put((byte)65).put(ephemeralPublicKeyBytes).put(this.encrypt(cek, nonce, plaintext)).array();
    }

    private byte[] encrypt(byte[] key, byte[] nonce, byte[] plaintext) throws GeneralSecurityException {
        Cipher cipher = (Cipher)EngineFactory.CIPHER.getInstance("AES/GCM/NoPadding");
        GCMParameterSpec params = new GCMParameterSpec(128, nonce);
        cipher.init(1, (Key)new SecretKeySpec(key, "AES"), params);
        byte[] paddedPlaintext = new byte[plaintext.length + 1 + this.paddingSize];
        paddedPlaintext[plaintext.length] = 2;
        System.arraycopy(plaintext, 0, paddedPlaintext, 0, plaintext.length);
        return cipher.doFinal(paddedPlaintext);
    }

    public static final class Builder {
        private byte[] recipientPublicKey = null;
        private ECPoint recipientPublicPoint = null;
        private byte[] authSecret = null;
        private int recordSize = 4096;
        private int paddingSize = 0;

        @CanIgnoreReturnValue
        public Builder withRecordSize(int val) {
            if (val < 18 || val > 4096) {
                throw new IllegalArgumentException(String.format("invalid record size (%s); must be a number between [%s, %s]", val, 103, 4096));
            }
            this.recordSize = val;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withPaddingSize(int val) {
            if (val < 0 || val > 3993) {
                throw new IllegalArgumentException(String.format("invalid padding size (%s); must be a number between [%s, %s]", val, 0, 3993));
            }
            this.paddingSize = val;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withAuthSecret(byte[] val) {
            this.authSecret = (byte[])val.clone();
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withRecipientPublicKey(ECPublicKey val) throws GeneralSecurityException {
            this.recipientPublicPoint = val.getW();
            this.recipientPublicKey = EllipticCurves.pointEncode((EllipticCurves.CurveType)WebPushConstants.NIST_P256_CURVE_TYPE, (EllipticCurves.PointFormatType)WebPushConstants.UNCOMPRESSED_POINT_FORMAT, (ECPoint)val.getW());
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withRecipientPublicKey(byte[] val) throws GeneralSecurityException {
            this.recipientPublicKey = (byte[])val.clone();
            this.recipientPublicPoint = EllipticCurves.pointDecode((EllipticCurves.CurveType)WebPushConstants.NIST_P256_CURVE_TYPE, (EllipticCurves.PointFormatType)WebPushConstants.UNCOMPRESSED_POINT_FORMAT, (byte[])this.recipientPublicKey);
            return this;
        }

        public WebPushHybridEncrypt build() throws GeneralSecurityException {
            return new WebPushHybridEncrypt(this);
        }
    }
}

