/*
 * Decompiled with CFR 0.152.
 */
package org.unifiedpush.android.connector;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import java.security.GeneralSecurityException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.unifiedpush.android.connector.FailedReason;
import org.unifiedpush.android.connector.FailedReasonKt;
import org.unifiedpush.android.connector.data.PublicKeySet;
import org.unifiedpush.android.connector.data.PushEndpoint;
import org.unifiedpush.android.connector.data.PushMessage;
import org.unifiedpush.android.connector.internal.Store;
import org.unifiedpush.android.connector.internal.WakeLock;
import org.unifiedpush.android.connector.keys.DefaultKeyManager;
import org.unifiedpush.android.connector.keys.KeyManager;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J*\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\nH\u0002J \u0010\r\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH&J \u0010\u0011\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\nH&J\u0018\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u0017\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\nH&J\u0018\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\nH&\u00a8\u0006\u001b"}, d2={"Lorg/unifiedpush/android/connector/MessagingReceiver;", "Landroid/content/BroadcastReceiver;", "()V", "getKeyManager", "Lorg/unifiedpush/android/connector/keys/KeyManager;", "context", "Landroid/content/Context;", "mayAcknowledgeMessage", "", "distributor", "", "id", "token", "onMessage", "message", "Lorg/unifiedpush/android/connector/data/PushMessage;", "instance", "onNewEndpoint", "endpoint", "Lorg/unifiedpush/android/connector/data/PushEndpoint;", "onReceive", "intent", "Landroid/content/Intent;", "onRegistrationFailed", "reason", "Lorg/unifiedpush/android/connector/FailedReason;", "onUnregistered", "connector_release"})
public abstract class MessagingReceiver
extends BroadcastReceiver {
    @NotNull
    public KeyManager getKeyManager(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new DefaultKeyManager(context);
    }

    public abstract void onNewEndpoint(@NotNull Context var1, @NotNull PushEndpoint var2, @NotNull String var3);

    public abstract void onRegistrationFailed(@NotNull Context var1, @NotNull FailedReason var2, @NotNull String var3);

    public abstract void onUnregistered(@NotNull Context var1, @NotNull String var2);

    public abstract void onMessage(@NotNull Context var1, @NotNull PushMessage var2, @NotNull String var3);

    public void onReceive(@NotNull Context context, @NotNull Intent intent) {
        WakeLock wakeLock;
        block30: {
            String string;
            KeyManager keyManager;
            Store store;
            String token;
            block29: {
                block28: {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                    token = intent.getStringExtra("token");
                    store = new Store(context);
                    keyManager = this.getKeyManager(context);
                    string = token;
                    if (string == null) break block28;
                    String it = string;
                    boolean bl = false;
                    String string2 = store.getRegistrationSet().tryGetInstance$connector_release(it);
                    string = string2;
                    if (string2 != null) break block29;
                }
                return;
            }
            String instance = string;
            wakeLock = new WakeLock(context);
            String string3 = intent.getAction();
            if (string3 == null) break block30;
            int n = -1;
            switch (string3.hashCode()) {
                case -1388708293: {
                    if (string3.equals("org.unifiedpush.android.connector.MESSAGE")) {
                        n = 1;
                    }
                    break;
                }
                case 1656169376: {
                    if (string3.equals("org.unifiedpush.android.connector.NEW_ENDPOINT")) {
                        n = 2;
                    }
                    break;
                }
                case -406014249: {
                    if (string3.equals("org.unifiedpush.android.connector.REGISTRATION_FAILED")) {
                        n = 3;
                    }
                    break;
                }
                case -515224569: {
                    if (string3.equals("org.unifiedpush.android.connector.UNREGISTERED")) {
                        n = 4;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    String string4 = intent.getStringExtra("endpoint");
                    if (string4 == null) {
                        return;
                    }
                    String endpoint = string4;
                    String id = intent.getStringExtra("id");
                    PublicKeySet pubKeys = keyManager.getPublicKeySet(instance);
                    store.setDistributorAck$connector_release(true);
                    this.onNewEndpoint(context, new PushEndpoint(endpoint, pubKeys), instance);
                    String string5 = store.tryGetDistributor$connector_release();
                    if (string5 != null) {
                        String it = string5;
                        boolean bl = false;
                        this.mayAcknowledgeMessage(context, it, id, token);
                    }
                    break;
                }
                case 3: {
                    Object reason = FailedReasonKt.toFailedReason(intent.getStringExtra("reason"));
                    Log.i((String)"UnifiedPush", (String)("Failed: " + reason));
                    store.getRegistrationSet().removeInstance$connector_release(instance, keyManager);
                    this.onRegistrationFailed(context, (FailedReason)((Object)reason), instance);
                    break;
                }
                case 4: {
                    this.onUnregistered(context, instance);
                    Object reason = store.getRegistrationSet().removeInstance$connector_release(instance, keyManager);
                    if (!reason.isEmpty()) break;
                    boolean bl = false;
                    store.removeDistributor$connector_release();
                    break;
                }
                case 1: {
                    PushMessage pushMessage;
                    byte[] byArray = intent.getByteArrayExtra("bytesMessage");
                    if (byArray == null) {
                        return;
                    }
                    byte[] message = byArray;
                    String id = intent.getStringExtra("id");
                    try {
                        PushMessage pushMessage2;
                        byte[] byArray2 = keyManager.decrypt(instance, message);
                        if (byArray2 != null) {
                            byte[] it = byArray2;
                            boolean bl = false;
                            pushMessage2 = new PushMessage(it, true);
                        } else {
                            pushMessage2 = new PushMessage(message, false);
                        }
                        pushMessage = pushMessage2;
                    }
                    catch (GeneralSecurityException e) {
                        Log.w((String)"UnifiedPush", (String)("Could not decrypt message, trying with plain text. Cause: " + e.getMessage()));
                        pushMessage = new PushMessage(message, false);
                    }
                    PushMessage pushMessage3 = pushMessage;
                    this.onMessage(context, pushMessage3, instance);
                    String string6 = store.tryGetDistributor$connector_release();
                    if (string6 != null) {
                        String it = string6;
                        boolean bl = false;
                        this.mayAcknowledgeMessage(context, it, id, token);
                    }
                    break;
                }
            }
        }
        wakeLock.release();
    }

    private final void mayAcknowledgeMessage(Context context, String distributor, String id, String token) {
        block0: {
            Intent intent;
            String string = id;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            Intent $this$mayAcknowledgeMessage_u24lambda_u246_u24lambda_u245 = intent = new Intent();
            boolean bl2 = false;
            $this$mayAcknowledgeMessage_u24lambda_u246_u24lambda_u245.setPackage(distributor);
            $this$mayAcknowledgeMessage_u24lambda_u246_u24lambda_u245.setAction("org.unifiedpush.android.distributor.MESSAGE_ACK");
            $this$mayAcknowledgeMessage_u24lambda_u246_u24lambda_u245.putExtra("token", token);
            $this$mayAcknowledgeMessage_u24lambda_u246_u24lambda_u245.putExtra("id", it);
            Intent broadcastIntent = intent;
            context.sendBroadcast(broadcastIntent);
        }
    }
}

