/*
 * Decompiled with CFR 0.152.
 */
package org.unifiedpush.android.connector.keys;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import com.google.crypto.tink.apps.fixed_webpush.WebPushHybridDecrypt;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.unifiedpush.android.connector.data.PublicKeySet;
import org.unifiedpush.android.connector.keys.KeyManager;
import org.unifiedpush.android.connector.keys.WebPushKeys;
import org.unifiedpush.android.connector.keys.WebPushKeysEntries;
import org.unifiedpush.android.connector.keys.WebPushKeysEntries23;
import org.unifiedpush.android.connector.keys.WebPushKeysEntriesLegacy;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/unifiedpush/android/connector/keys/DefaultKeyManager;", "Lorg/unifiedpush/android/connector/keys/KeyManager;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "preferences", "Landroid/content/SharedPreferences;", "kotlin.jvm.PlatformType", "decrypt", "", "instance", "", "sealed", "delete", "", "exists", "", "generate", "getKeyStoreEntries", "Lorg/unifiedpush/android/connector/keys/WebPushKeysEntries;", "getPublicKeySet", "Lorg/unifiedpush/android/connector/data/PublicKeySet;", "connector_release"})
public final class DefaultKeyManager
implements KeyManager {
    private final SharedPreferences preferences;

    public DefaultKeyManager(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.preferences = context.getSharedPreferences("unifiedpush.connector", 0);
    }

    @Override
    @Nullable
    public byte[] decrypt(@NotNull String instance, @NotNull byte[] sealed) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        Intrinsics.checkNotNullParameter((Object)sealed, (String)"sealed");
        WebPushKeys webPushKeys = this.getKeyStoreEntries(instance).getOrNullWebPushKeys();
        if (webPushKeys == null) {
            return null;
        }
        WebPushKeys keys = webPushKeys;
        WebPushHybridDecrypt.Builder builder = new WebPushHybridDecrypt.Builder().withAuthSecret(keys.getAuth());
        PublicKey publicKey = keys.getKeyPair().getPublic();
        Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
        WebPushHybridDecrypt.Builder builder2 = builder.withRecipientPublicKey((ECPublicKey)publicKey);
        PrivateKey privateKey = keys.getKeyPair().getPrivate();
        Intrinsics.checkNotNull((Object)privateKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPrivateKey");
        WebPushHybridDecrypt hybridDecrypt = builder2.withRecipientPrivateKey((ECPrivateKey)privateKey).build();
        return hybridDecrypt.decrypt(sealed, null);
    }

    @Override
    public void generate(@NotNull String instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        this.getKeyStoreEntries(instance).genWebPushKeys();
    }

    @Override
    @Nullable
    public PublicKeySet getPublicKeySet(@NotNull String instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        WebPushKeys webPushKeys = this.getKeyStoreEntries(instance).getOrNullWebPushKeys();
        return webPushKeys != null ? webPushKeys.getPublicKeySet() : null;
    }

    @Override
    public boolean exists(@NotNull String instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        return this.getKeyStoreEntries(instance).getOrNullWebPushKeys() != null;
    }

    @Override
    public void delete(@NotNull String instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        this.getKeyStoreEntries(instance).deleteWebPushKeys();
    }

    private final WebPushKeysEntries getKeyStoreEntries(String instance) {
        WebPushKeysEntries webPushKeysEntries;
        if (Build.VERSION.SDK_INT >= 23) {
            SharedPreferences sharedPreferences = this.preferences;
            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"preferences");
            webPushKeysEntries = new WebPushKeysEntries23(instance, sharedPreferences);
        } else {
            SharedPreferences sharedPreferences = this.preferences;
            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"preferences");
            webPushKeysEntries = new WebPushKeysEntriesLegacy(instance, sharedPreferences);
        }
        return webPushKeysEntries;
    }
}

