/*
 * Decompiled with CFR 0.152.
 */
package org.unifiedpush.android.connector.keys;

import android.util.Base64;
import com.google.crypto.tink.subtle.EllipticCurves;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u0012\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0002*\u00020\u0001H\u0000\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0002H\u0000\u001a\f\u0010\u0006\u001a\u00020\u0002*\u00020\u0005H\u0000\u00a8\u0006\u0007"}, d2={"b64decode", "", "", "b64encode", "deserializePubKey", "Ljava/security/interfaces/ECPublicKey;", "serialize", "connector_release"})
public final class UtilsKt {
    @NotNull
    public static final String serialize(@NotNull ECPublicKey $this$serialize) {
        Intrinsics.checkNotNullParameter((Object)$this$serialize, (String)"<this>");
        byte[] byArray = EllipticCurves.pointEncode((EllipticCurves.CurveType)EllipticCurves.CurveType.NIST_P256, (EllipticCurves.PointFormatType)EllipticCurves.PointFormatType.UNCOMPRESSED, (ECPoint)$this$serialize.getW());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"pointEncode(\n        Ell\u2026ED,\n        this.w,\n    )");
        return UtilsKt.b64encode(byArray);
    }

    @NotNull
    public static final ECPublicKey deserializePubKey(@NotNull String $this$deserializePubKey) {
        Intrinsics.checkNotNullParameter((Object)$this$deserializePubKey, (String)"<this>");
        ECPoint point = EllipticCurves.pointDecode((EllipticCurves.CurveType)EllipticCurves.CurveType.NIST_P256, (EllipticCurves.PointFormatType)EllipticCurves.PointFormatType.UNCOMPRESSED, (byte[])UtilsKt.b64decode($this$deserializePubKey));
        ECParameterSpec spec = EllipticCurves.getCurveSpec((EllipticCurves.CurveType)EllipticCurves.CurveType.NIST_P256);
        PublicKey publicKey = KeyFactory.getInstance("EC").generatePublic(new ECPublicKeySpec(point, spec));
        Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
        return (ECPublicKey)publicKey;
    }

    @NotNull
    public static final String b64encode(@NotNull byte[] $this$b64encode) {
        Intrinsics.checkNotNullParameter((Object)$this$b64encode, (String)"<this>");
        String string = Base64.encodeToString((byte[])$this$b64encode, (int)11);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(\n        \u2026 Base64.NO_PADDING,\n    )");
        return string;
    }

    @NotNull
    public static final byte[] b64decode(@NotNull String $this$b64decode) {
        Intrinsics.checkNotNullParameter((Object)$this$b64decode, (String)"<this>");
        byte[] byArray = Base64.decode((String)$this$b64decode, (int)11);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(\n        this,\n  \u2026 Base64.NO_PADDING,\n    )");
        return byArray;
    }
}

