/*
 * Decompiled with CFR 0.152.
 */
package org.unifiedpush.android.connector.keys;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.unifiedpush.android.connector.data.PublicKeySet;
import org.unifiedpush.android.connector.keys.UtilsKt;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lorg/unifiedpush/android/connector/keys/WebPushKeys;", "", "auth", "", "keyPair", "Ljava/security/KeyPair;", "([BLjava/security/KeyPair;)V", "getAuth", "()[B", "getKeyPair", "()Ljava/security/KeyPair;", "publicKeySet", "Lorg/unifiedpush/android/connector/data/PublicKeySet;", "getPublicKeySet", "()Lorg/unifiedpush/android/connector/data/PublicKeySet;", "Companion", "connector_release"})
public final class WebPushKeys {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] auth;
    @NotNull
    private final KeyPair keyPair;

    public WebPushKeys(@NotNull byte[] auth, @NotNull KeyPair keyPair) {
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        this.auth = auth;
        this.keyPair = keyPair;
    }

    @NotNull
    public final byte[] getAuth() {
        return this.auth;
    }

    @NotNull
    public final KeyPair getKeyPair() {
        return this.keyPair;
    }

    @NotNull
    public final PublicKeySet getPublicKeySet() {
        PublicKey publicKey = this.keyPair.getPublic();
        Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
        return new PublicKeySet(UtilsKt.serialize((ECPublicKey)publicKey), UtilsKt.b64encode(this.auth));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/unifiedpush/android/connector/keys/WebPushKeys$Companion;", "", "()V", "generateAuthSecret", "", "generateKeyPair", "Ljava/security/KeyPair;", "new", "Lorg/unifiedpush/android/connector/keys/WebPushKeys;", "connector_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WebPushKeys new() {
            KeyPair keyPair = this.generateKeyPair();
            byte[] byArray = this.generateAuthSecret();
            return new WebPushKeys(byArray, keyPair);
        }

        private final KeyPair generateKeyPair() {
            KeyPairGenerator keyPairGenerator;
            KeyPairGenerator $this$generateKeyPair_u24lambda_u240 = keyPairGenerator = KeyPairGenerator.getInstance("EC");
            boolean bl = false;
            $this$generateKeyPair_u24lambda_u240.initialize(new ECGenParameterSpec("secp256r1"));
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"getInstance(\"EC\").apply \u2026      }.generateKeyPair()");
            return keyPair;
        }

        private final byte[] generateAuthSecret() {
            byte[] byArray;
            byte[] $this$generateAuthSecret_u24lambda_u241 = byArray = new byte[16];
            boolean bl = false;
            new SecureRandom().nextBytes($this$generateAuthSecret_u24lambda_u241);
            return byArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

