/*
 * Decompiled with CFR 0.152.
 */
package org.unifiedpush.android.connector.keys;

import android.content.SharedPreferences;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Log;
import androidx.annotation.RequiresApi;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.AEADBadTagException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.unifiedpush.android.connector.keys.UtilsKt;
import org.unifiedpush.android.connector.keys.WebPushKeys;
import org.unifiedpush.android.connector.keys.WebPushKeysEntries;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0001\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\n\u0010\u0012\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/unifiedpush/android/connector/keys/WebPushKeysEntries23;", "Lorg/unifiedpush/android/connector/keys/WebPushKeysEntries;", "instance", "", "prefs", "Landroid/content/SharedPreferences;", "(Ljava/lang/String;Landroid/content/SharedPreferences;)V", "deleteWebPushKeys", "", "genWebPushKeys", "Lorg/unifiedpush/android/connector/keys/WebPushKeys;", "getAesGcmCipher", "Ljavax/crypto/Cipher;", "iIV", "", "getNewAesGcmCipher", "getSecretKey", "Ljavax/crypto/SecretKey;", "getWebPushKeys", "hasWebPushKeys", "", "Companion", "connector_release"})
@RequiresApi(value=23)
public final class WebPushKeysEntries23
implements WebPushKeysEntries {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String instance;
    @NotNull
    private final SharedPreferences prefs;
    @NotNull
    private static final String KEYSTORE_PROVIDER = "AndroidKeyStore";
    @NotNull
    private static final String ALIAS = "UnifiedPush";

    public WebPushKeysEntries23(@NotNull String instance, @NotNull SharedPreferences prefs) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        Intrinsics.checkNotNullParameter((Object)prefs, (String)"prefs");
        this.instance = instance;
        this.prefs = prefs;
    }

    @Override
    @Nullable
    public WebPushKeys getWebPushKeys() {
        Object object = "%s/unifiedpush.webpush.auth";
        Object object2 = new Object[]{this.instance};
        String string = String.format((String)object, Arrays.copyOf(object2, ((Object[])object2).length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        String string2 = this.prefs.getString(string, null);
        if (string2 == null || (object = (Object)UtilsKt.b64decode(string2)) == null) {
            return null;
        }
        Object auth = object;
        object2 = "%s/unifiedpush.webpush.iv";
        Object object3 = new Object[]{this.instance};
        String string3 = String.format((String)object2, Arrays.copyOf(object3, ((Object[])object3).length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        object = this.prefs.getString(string3, null);
        if (object == null || (object2 = (Object)UtilsKt.b64decode((String)object)) == null) {
            return null;
        }
        Object iv = object2;
        object3 = "%s/unifiedpush.webpush.privkey";
        Object object4 = new Object[]{this.instance};
        String string4 = String.format((String)object3, Arrays.copyOf(object4, ((Object[])object4).length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        object2 = this.prefs.getString(string4, null);
        if (object2 == null || (object3 = (Object)UtilsKt.b64decode((String)object2)) == null) {
            return null;
        }
        Object sealedPrivateKey = object3;
        object4 = "%s/unifiedpush.webpush.pubkey";
        Object[] objectArray = new Object[]{this.instance};
        String string5 = String.format((String)object4, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
        object3 = this.prefs.getString(string5, null);
        if (object3 == null || (object4 = UtilsKt.deserializePubKey((String)object3)) == null) {
            return null;
        }
        Object publicKey = object4;
        Cipher cipher = this.getAesGcmCipher((byte[])iv);
        try {
            objectArray = cipher.doFinal((byte[])sealedPrivateKey);
        }
        catch (AEADBadTagException e) {
            Log.e((String)ALIAS, (String)("AEADBadTagException caught for " + this.instance + ", a new keypair must be generated."), (Throwable)e);
            return null;
        }
        Object[] privateBytes = objectArray;
        PrivateKey privateKey = KeyFactory.getInstance("EC").generatePrivate(new PKCS8EncodedKeySpec((byte[])privateBytes));
        return new WebPushKeys((byte[])auth, new KeyPair((PublicKey)publicKey, privateKey));
    }

    @Override
    @NotNull
    public WebPushKeys genWebPushKeys() {
        WebPushKeys keys = WebPushKeys.Companion.new();
        Cipher cipher = this.getNewAesGcmCipher();
        byte[] sealedPrivateKey = cipher.doFinal(keys.getKeyPair().getPrivate().getEncoded());
        SharedPreferences.Editor editor = this.prefs.edit();
        String string = "%s/unifiedpush.webpush.auth";
        Object[] objectArray = new Object[]{this.instance};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        SharedPreferences.Editor editor2 = editor.putString(string2, UtilsKt.b64encode(keys.getAuth()));
        string = "%s/unifiedpush.webpush.iv";
        objectArray = new Object[]{this.instance};
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        byte[] byArray = cipher.getIV();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cipher.iv");
        SharedPreferences.Editor editor3 = editor2.putString(string3, UtilsKt.b64encode(byArray));
        string = "%s/unifiedpush.webpush.pubkey";
        objectArray = new Object[]{this.instance};
        String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        PublicKey publicKey = keys.getKeyPair().getPublic();
        Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
        SharedPreferences.Editor editor4 = editor3.putString(string4, UtilsKt.serialize((ECPublicKey)publicKey));
        string = "%s/unifiedpush.webpush.privkey";
        objectArray = new Object[]{this.instance};
        String string5 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
        Intrinsics.checkNotNullExpressionValue((Object)sealedPrivateKey, (String)"sealedPrivateKey");
        editor4.putString(string5, UtilsKt.b64encode(sealedPrivateKey)).apply();
        return keys;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasWebPushKeys() {
        Object object = KeyStore.getInstance(KEYSTORE_PROVIDER);
        KeyStore $this$hasWebPushKeys_u24lambda_u240 = object;
        boolean bl = false;
        $this$hasWebPushKeys_u24lambda_u240.load(null);
        KeyStore ks = object;
        object = "%s/unifiedpush.webpush.iv";
        Object[] objectArray = new Object[]{this.instance};
        String string = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        if (!this.prefs.contains(string)) return false;
        object = "%s/unifiedpush.webpush.auth";
        objectArray = new Object[]{this.instance};
        String string2 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        if (!this.prefs.contains(string2)) return false;
        object = "%s/unifiedpush.webpush.pubkey";
        objectArray = new Object[]{this.instance};
        String string3 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        if (!this.prefs.contains(string3)) return false;
        object = "%s/unifiedpush.webpush.privkey";
        objectArray = new Object[]{this.instance};
        String string4 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        if (!this.prefs.contains(string4)) return false;
        if (!ks.containsAlias(ALIAS)) return false;
        if ((KeyStore.SecretKeyEntry)ks.getEntry(ALIAS, null) == null) return false;
        return true;
    }

    @Override
    public void deleteWebPushKeys() {
        Log.d((String)ALIAS, (String)"Deleting webpush keys");
        SharedPreferences.Editor editor = this.prefs.edit();
        String string = "%s/unifiedpush.webpush.auth";
        Object[] objectArray = new Object[]{this.instance};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        SharedPreferences.Editor editor2 = editor.remove(string2);
        string = "%s/unifiedpush.webpush.iv";
        objectArray = new Object[]{this.instance};
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        SharedPreferences.Editor editor3 = editor2.remove(string3);
        string = "%s/unifiedpush.webpush.pubkey";
        objectArray = new Object[]{this.instance};
        String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        SharedPreferences.Editor editor4 = editor3.remove(string4);
        string = "%s/unifiedpush.webpush.privkey";
        objectArray = new Object[]{this.instance};
        String string5 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
        editor4.remove(string5).apply();
    }

    private final SecretKey getSecretKey() {
        KeyGenerator keyGenerator;
        KeyStore keyStore;
        KeyStore $this$getSecretKey_u24lambda_u241 = keyStore = KeyStore.getInstance(KEYSTORE_PROVIDER);
        boolean bl = false;
        $this$getSecretKey_u24lambda_u241.load(null);
        KeyStore ks = keyStore;
        if (ks.containsAlias(ALIAS)) {
            KeyStore.Entry entry = ks.getEntry(ALIAS, null);
            Intrinsics.checkNotNull((Object)entry, (String)"null cannot be cast to non-null type java.security.KeyStore.SecretKeyEntry");
            SecretKey secretKey = ((KeyStore.SecretKeyEntry)entry).getSecretKey();
            Intrinsics.checkNotNullExpressionValue((Object)secretKey, (String)"ks.getEntry(ALIAS, null)\u2026SecretKeyEntry).secretKey");
            return secretKey;
        }
        KeyGenerator $this$getSecretKey_u24lambda_u242 = keyGenerator = KeyGenerator.getInstance("AES", KEYSTORE_PROVIDER);
        boolean bl2 = false;
        String[] stringArray = new String[]{"GCM"};
        KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(ALIAS, 3).setBlockModes(stringArray);
        stringArray = new String[]{"NoPadding"};
        $this$getSecretKey_u24lambda_u242.init((AlgorithmParameterSpec)builder.setEncryptionPaddings(stringArray).build());
        SecretKey secretKey = keyGenerator.generateKey();
        Intrinsics.checkNotNullExpressionValue((Object)secretKey, (String)"getInstance(KeyPropertie\u2026)\n        }.generateKey()");
        return secretKey;
    }

    private final Cipher getNewAesGcmCipher() {
        Cipher cipher;
        SecretKey secretKey = this.getSecretKey();
        Cipher $this$getNewAesGcmCipher_u24lambda_u243 = cipher = Cipher.getInstance("AES/GCM/NoPadding");
        boolean bl = false;
        $this$getNewAesGcmCipher_u24lambda_u243.init(1, secretKey);
        Cipher cipher2 = cipher;
        Intrinsics.checkNotNullExpressionValue((Object)cipher2, (String)"getInstance(\"AES/GCM/NoP\u2026,\n            )\n        }");
        return cipher2;
    }

    private final Cipher getAesGcmCipher(byte[] iIV) {
        Cipher cipher;
        KeyStore keyStore;
        KeyStore $this$getAesGcmCipher_u24lambda_u244 = keyStore = KeyStore.getInstance(KEYSTORE_PROVIDER);
        boolean bl = false;
        $this$getAesGcmCipher_u24lambda_u244.load(null);
        KeyStore ks = keyStore;
        ks.containsAlias(ALIAS);
        SecretKey secretKey = this.getSecretKey();
        Cipher $this$getAesGcmCipher_u24lambda_u245 = cipher = Cipher.getInstance("AES/GCM/NoPadding");
        boolean bl2 = false;
        $this$getAesGcmCipher_u24lambda_u245.init(2, (Key)secretKey, new GCMParameterSpec(128, iIV));
        Cipher cipher2 = cipher;
        Intrinsics.checkNotNullExpressionValue((Object)cipher2, (String)"getInstance(\"AES/GCM/NoP\u2026,\n            )\n        }");
        return cipher2;
    }

    @Override
    @Nullable
    public WebPushKeys getOrNullWebPushKeys() {
        return WebPushKeysEntries.DefaultImpls.getOrNullWebPushKeys(this);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/unifiedpush/android/connector/keys/WebPushKeysEntries23$Companion;", "", "()V", "ALIAS", "", "KEYSTORE_PROVIDER", "connector_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

