/*
 * Decompiled with CFR 0.152.
 */
package org.unifiedpush.android.connector.keys;

import android.content.SharedPreferences;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.unifiedpush.android.connector.keys.UtilsKt;
import org.unifiedpush.android.connector.keys.WebPushKeys;
import org.unifiedpush.android.connector.keys.WebPushKeysEntries;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/unifiedpush/android/connector/keys/WebPushKeysEntriesLegacy;", "Lorg/unifiedpush/android/connector/keys/WebPushKeysEntries;", "instance", "", "prefs", "Landroid/content/SharedPreferences;", "(Ljava/lang/String;Landroid/content/SharedPreferences;)V", "deleteWebPushKeys", "", "genWebPushKeys", "Lorg/unifiedpush/android/connector/keys/WebPushKeys;", "getWebPushKeys", "hasWebPushKeys", "", "connector_release"})
public final class WebPushKeysEntriesLegacy
implements WebPushKeysEntries {
    @NotNull
    private final String instance;
    @NotNull
    private final SharedPreferences prefs;

    public WebPushKeysEntriesLegacy(@NotNull String instance, @NotNull SharedPreferences prefs) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        Intrinsics.checkNotNullParameter((Object)prefs, (String)"prefs");
        this.instance = instance;
        this.prefs = prefs;
    }

    @Override
    @Nullable
    public WebPushKeys getWebPushKeys() {
        Object object = "%s/unifiedpush.webpush.auth";
        Object object2 = new Object[]{this.instance};
        String string = String.format((String)object, Arrays.copyOf(object2, ((Object[])object2).length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        String string2 = this.prefs.getString(string, null);
        if (string2 == null || (object = (Object)UtilsKt.b64decode(string2)) == null) {
            return null;
        }
        Object auth = object;
        object2 = "%s/unifiedpush.webpush.privkey";
        Object object3 = new Object[]{this.instance};
        String string3 = String.format((String)object2, Arrays.copyOf(object3, ((Object[])object3).length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        object = this.prefs.getString(string3, null);
        if (object == null || (object2 = (Object)UtilsKt.b64decode((String)object)) == null) {
            return null;
        }
        Object privateBytes = object2;
        object3 = "%s/unifiedpush.webpush.pubkey";
        Object[] objectArray = new Object[]{this.instance};
        String string4 = String.format((String)object3, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        object2 = this.prefs.getString(string4, null);
        if (object2 == null || (object3 = UtilsKt.deserializePubKey((String)object2)) == null) {
            return null;
        }
        Object publicKey = object3;
        PrivateKey privateKey = KeyFactory.getInstance("EC").generatePrivate(new PKCS8EncodedKeySpec((byte[])privateBytes));
        return new WebPushKeys((byte[])auth, new KeyPair((PublicKey)publicKey, privateKey));
    }

    @Override
    @NotNull
    public WebPushKeys genWebPushKeys() {
        WebPushKeys keys = WebPushKeys.Companion.new();
        SharedPreferences.Editor editor = this.prefs.edit();
        String string = "%s/unifiedpush.webpush.auth";
        Object[] objectArray = new Object[]{this.instance};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        SharedPreferences.Editor editor2 = editor.putString(string2, UtilsKt.b64encode(keys.getAuth()));
        string = "%s/unifiedpush.webpush.pubkey";
        objectArray = new Object[]{this.instance};
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        PublicKey publicKey = keys.getKeyPair().getPublic();
        Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
        SharedPreferences.Editor editor3 = editor2.putString(string3, UtilsKt.serialize((ECPublicKey)publicKey));
        string = "%s/unifiedpush.webpush.privkey";
        objectArray = new Object[]{this.instance};
        String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        byte[] byArray = keys.getKeyPair().getPrivate().getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"keys.keyPair.private.encoded");
        editor3.putString(string4, UtilsKt.b64encode(byArray)).apply();
        return keys;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasWebPushKeys() {
        String string = "%s/unifiedpush.webpush.auth";
        Object[] objectArray = new Object[]{this.instance};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        if (!this.prefs.contains(string2)) return false;
        string = "%s/unifiedpush.webpush.pubkey";
        objectArray = new Object[]{this.instance};
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        if (!this.prefs.contains(string3)) return false;
        string = "%s/unifiedpush.webpush.privkey";
        objectArray = new Object[]{this.instance};
        String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        if (!this.prefs.contains(string4)) return false;
        return true;
    }

    @Override
    public void deleteWebPushKeys() {
        SharedPreferences.Editor editor = this.prefs.edit();
        String string = "%s/unifiedpush.webpush.auth";
        Object[] objectArray = new Object[]{this.instance};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        SharedPreferences.Editor editor2 = editor.remove(string2);
        string = "%s/unifiedpush.webpush.pubkey";
        objectArray = new Object[]{this.instance};
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        SharedPreferences.Editor editor3 = editor2.remove(string3);
        string = "%s/unifiedpush.webpush.privkey";
        objectArray = new Object[]{this.instance};
        String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        editor3.remove(string4).apply();
    }

    @Override
    @Nullable
    public WebPushKeys getOrNullWebPushKeys() {
        return WebPushKeysEntries.DefaultImpls.getOrNullWebPushKeys(this);
    }
}

