/*
 * Decompiled with CFR 0.152.
 */
package org.unifiedpush.android.embedded_fcm_distributor;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.util.Log;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.tasks.Task;
import com.google.firebase.messaging.FirebaseMessaging;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.unifiedpush.android.embedded_fcm_distributor.Utils;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0003\u00a8\u0006\u000e"}, d2={"Lorg/unifiedpush/android/embedded_fcm_distributor/EmbeddedDistributorReceiver;", "Landroid/content/BroadcastReceiver;", "()V", "getEndpoint", "", "context", "Landroid/content/Context;", "token", "instance", "onReceive", "", "intent", "Landroid/content/Intent;", "saveGetEndpoint", "lib_release"})
public class EmbeddedDistributorReceiver
extends BroadcastReceiver {
    @NotNull
    public String getEndpoint(@NotNull Context context, @NotNull String token, @NotNull String instance) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onReceive(@NotNull Context context, @NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        String string = intent.getStringExtra("token");
        if (string == null) {
            return;
        }
        String token = string;
        Log.d((String)"UP-Embedded_distributor", (String)("New intent for " + token));
        String string2 = intent.getAction();
        if (string2 == null) return;
        switch (string2.hashCode()) {
            case -914659634: {
                if (string2.equals("org.unifiedpush.android.distributor.UNREGISTER")) break;
                return;
            }
            case 1024164277: {
                if (!string2.equals("org.unifiedpush.android.distributor.REGISTER")) return;
                Log.d((String)"UP-Embedded_distributor", (String)"Registering to the embedded distributor");
                this.saveGetEndpoint(context);
                Utils.INSTANCE.saveToken(context, token);
                switch (GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(context)) {
                    case 0: {
                        Log.d((String)"UP-Embedded_distributor", (String)"PlayServices available");
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 9: {
                        Log.w((String)"UP-Embedded_distributor", (String)"PlayServices Missing, disabled or invalid. Sending registration failed");
                        Utils.INSTANCE.sendRegistrationFailed(context, token, "PlayServices not available");
                        return;
                    }
                    case 2: 
                    case 18: {
                        Log.w((String)"UP-Embedded_distributor", (String)"PlayServices updating or require an update.");
                        Utils.INSTANCE.sendRegistrationFailed(context, token, "PlayServices temporarily not available");
                        return;
                    }
                }
                FirebaseMessaging.getInstance().getToken().addOnCompleteListener(arg_0 -> EmbeddedDistributorReceiver.onReceive$lambda$0(context, token, arg_0));
                return;
            }
        }
        Log.d((String)"UP-Embedded_distributor", (String)"Fake Distributor unregister");
        Utils.INSTANCE.removeToken(context, token);
        Intent broadcastIntent = new Intent();
        broadcastIntent.setPackage(context.getPackageName());
        broadcastIntent.setAction("org.unifiedpush.android.connector.UNREGISTERED");
        broadcastIntent.putExtra("token", token);
        context.sendBroadcast(broadcastIntent);
    }

    @SuppressLint(value={"ApplySharedPref"})
    private final void saveGetEndpoint(Context context) {
        SharedPreferences prefs = context.getSharedPreferences("UP-embedded_fcm", 0);
        String ff = "\u00ff";
        prefs.edit().putString("getEndpoint", this.getEndpoint(context, ff + ff + ".TOKEN." + ff + ff, ff + ff + ".INSTANCE." + ff + ff)).commit();
    }

    private static final void onReceive$lambda$0(Context $context, String $token, Task task) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$token, (String)"$token");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (task.isSuccessful()) {
            String fcmToken = (String)task.getResult();
            Log.d((String)"UP-Embedded_distributor", (String)("Token successfully received: " + fcmToken));
            Intrinsics.checkNotNullExpressionValue((Object)fcmToken, (String)"fcmToken");
            Utils.INSTANCE.sendNewEndpoint($context, fcmToken, $token);
        } else {
            Exception exception = task.getException();
            Log.w((String)"UP-Embedded_distributor", (String)("FCMToken registration failed: " + (exception != null ? exception.getLocalizedMessage() : null)));
            Utils.INSTANCE.sendRegistrationFailed($context, $token, "FCM (PlayServices) token not received");
        }
    }
}

