/*
 * Decompiled with CFR 0.152.
 */
package org.unifiedpush.android.embedded_fcm_distributor;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0004J\u0016\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0004J\u001e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004J\u001e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004\u00a8\u0006\u0013"}, d2={"Lorg/unifiedpush/android/embedded_fcm_distributor/Utils;", "", "()V", "getEndpoint", "", "context", "Landroid/content/Context;", "fcmToken", "instance", "getTokens", "", "removeToken", "", "token", "saveToken", "sendNewEndpoint", "connectionToken", "sendRegistrationFailed", "message", "lib_release"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    @NotNull
    public final Set<String> getTokens(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences prefs = context.getSharedPreferences("UP-embedded_fcm", 0);
        Set set = prefs.getStringSet("UP-embedded_fcm:tokens", null);
        return set == null ? (Set)new LinkedHashSet() : set;
    }

    public final void saveToken(@NotNull Context context, @NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Set<String> tokens = this.getTokens(context);
        if (!tokens.contains(token)) {
            tokens.add(token);
            SharedPreferences prefs = context.getSharedPreferences("UP-embedded_fcm", 0);
            prefs.edit().putStringSet("UP-embedded_fcm:tokens", tokens).apply();
        }
    }

    public final void removeToken(@NotNull Context context, @NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Set<String> tokens = this.getTokens(context);
        if (tokens.contains(token)) {
            tokens.remove(token);
            SharedPreferences prefs = context.getSharedPreferences("UP-embedded_fcm", 0);
            prefs.edit().putStringSet("UP-embedded_fcm:tokens", tokens).apply();
        }
    }

    public final void sendNewEndpoint(@NotNull Context context, @NotNull String fcmToken, @NotNull String connectionToken) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fcmToken, (String)"fcmToken");
        Intrinsics.checkNotNullParameter((Object)connectionToken, (String)"connectionToken");
        Intent broadcastIntent = new Intent();
        broadcastIntent.setPackage(context.getPackageName());
        broadcastIntent.setAction("org.unifiedpush.android.connector.NEW_ENDPOINT");
        broadcastIntent.putExtra("endpoint", this.getEndpoint(context, fcmToken, connectionToken));
        broadcastIntent.putExtra("token", connectionToken);
        context.sendBroadcast(broadcastIntent);
    }

    public final void sendRegistrationFailed(@NotNull Context context, @NotNull String connectionToken, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)connectionToken, (String)"connectionToken");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intent broadcastIntent = new Intent();
        broadcastIntent.setPackage(context.getPackageName());
        broadcastIntent.setAction("org.unifiedpush.android.connector.REGISTRATION_FAILED");
        broadcastIntent.putExtra("token", connectionToken);
        broadcastIntent.putExtra("message", message);
        context.sendBroadcast(broadcastIntent);
    }

    private final String getEndpoint(Context context, String fcmToken, String instance) {
        String string;
        SharedPreferences prefs = context.getSharedPreferences("UP-embedded_fcm", 0);
        String ff = "\u00ff";
        String string2 = prefs.getString("getEndpoint", null);
        return string2 != null && (string = StringsKt.replace$default((String)string2, (String)(ff + ff + ".TOKEN." + ff + ff), (String)fcmToken, (boolean)false, (int)4, null)) != null ? StringsKt.replace$default((String)string, (String)(ff + ff + ".INSTANCE." + ff + ff), (String)instance, (boolean)false, (int)4, null) : null;
    }
}

