/*
 * Decompiled with CFR 0.152.
 */
package org.unifiedpush.android.embedded_fcm_distributor;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.unifiedpush.android.embedded_fcm_distributor.FailedReason;
import org.unifiedpush.android.embedded_fcm_distributor.Gateway;
import org.unifiedpush.android.embedded_fcm_distributor.Utils;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/unifiedpush/android/embedded_fcm_distributor/EmbeddedDistributorReceiver;", "Landroid/content/BroadcastReceiver;", "()V", "gateway", "Lorg/unifiedpush/android/embedded_fcm_distributor/Gateway;", "getGateway", "()Lorg/unifiedpush/android/embedded_fcm_distributor/Gateway;", "checkAppOrigin", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "isPlayServicesAvailable", "onReceive", "", "embedded_fcm_distributor_release"})
public class EmbeddedDistributorReceiver
extends BroadcastReceiver {
    @Nullable
    private final Gateway gateway;

    @Nullable
    public Gateway getGateway() {
        return this.gateway;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onReceive(@NotNull Context context, @NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        String string = intent.getStringExtra("token");
        if (string == null) {
            return;
        }
        String token = string;
        StringBuilder stringBuilder = new StringBuilder().append("New intent for ");
        String string2 = token.substring(0, 3);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        Log.d((String)"UP-FCMD", (String)stringBuilder.append(string2).append("xxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxxx").toString());
        String string3 = intent.getAction();
        if (string3 == null) return;
        switch (string3.hashCode()) {
            case -914659634: {
                if (string3.equals("org.unifiedpush.android.distributor.UNREGISTER")) break;
                return;
            }
            case 1024164277: {
                if (!string3.equals("org.unifiedpush.android.distributor.REGISTER")) return;
                if (!this.checkAppOrigin(context, intent)) {
                    Log.d((String)"UP-FCMD", (String)"Received an intent from another package. Aborting.");
                    return;
                }
                Log.d((String)"UP-FCMD", (String)"Registering to the embedded distributor");
                boolean useGateway = false;
                if (!this.isPlayServicesAvailable(context)) {
                    Utils.INSTANCE.sendRegistrationFailed(context, token, FailedReason.ACTION_REQUIRED);
                    return;
                }
                String string4 = intent.getStringExtra("vapid");
                if (string4 == null) {
                    String string5;
                    Gateway gateway = this.getGateway();
                    if (gateway != null) {
                        Gateway it = gateway;
                        boolean bl = false;
                        Utils.INSTANCE.saveEndpoint(context, it);
                        useGateway = true;
                        string5 = it.getVapid();
                    } else {
                        string5 = string4 = null;
                    }
                    if (string5 == null) {
                        EmbeddedDistributorReceiver $this$onReceive_u24lambda_u241 = this;
                        boolean bl = false;
                        Log.d((String)"UP-FCMD", (String)"Received registration without a VAPID key. And gatewayis not defined: sending registration failed with VAPID_REQUIRED reason");
                        Utils.INSTANCE.sendRegistrationFailed(context, token, FailedReason.VAPID_REQUIRED);
                        return;
                    }
                }
                String vapid = string4;
                Utils.INSTANCE.registerFCM(context, token, vapid, useGateway);
                return;
            }
        }
        Log.d((String)"UP-FCMD", (String)"Unregistered");
        Utils.INSTANCE.sendUnregistered(context, token);
    }

    private final boolean checkAppOrigin(Context context, Intent intent) {
        String string;
        if (Build.VERSION.SDK_INT < 17) {
            string = context.getPackageName();
        } else if (Build.VERSION.SDK_INT >= 34) {
            string = this.getSentFromPackage();
        } else {
            PendingIntent pendingIntent = (PendingIntent)intent.getParcelableExtra("pi");
            string = pendingIntent != null ? pendingIntent.getCreatorPackage() : null;
        }
        return Intrinsics.areEqual((Object)string, (Object)context.getPackageName());
    }

    private final boolean isPlayServicesAvailable(Context context) {
        PackageManager pm = context.getPackageManager();
        try {
            pm.getPackageInfo("com.google.android.gms", 1);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            String string = e.getMessage();
            Intrinsics.checkNotNull((Object)string);
            Log.v((String)"UP-FCMD", (String)string);
            return false;
        }
    }
}

